/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import net.java.games.jogl.DefaultGLCapabilitiesChooser;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLJPanel;
import net.java.games.jogl.impl.GLContextFactory;

public class GLDrawableFactory {
    private static GLDrawableFactory factory = new GLDrawableFactory();

    private GLDrawableFactory() {
    }

    public static GLDrawableFactory getFactory() {
        return factory;
    }

    public GLCanvas createGLCanvas(GLCapabilities gLCapabilities) {
        return this.createGLCanvas(gLCapabilities, null, null);
    }

    public GLCanvas createGLCanvas(GLCapabilities gLCapabilities, GLDrawable gLDrawable) {
        return this.createGLCanvas(gLCapabilities, null, gLDrawable);
    }

    public GLCanvas createGLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return this.createGLCanvas(gLCapabilities, gLCapabilitiesChooser, null);
    }

    public GLCanvas createGLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLDrawable gLDrawable) {
        return this.createGLCanvas(gLCapabilities, gLCapabilitiesChooser, gLDrawable, null);
    }

    public GLCanvas createGLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLDrawable gLDrawable, GraphicsDevice graphicsDevice) {
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        if (graphicsDevice == null) {
            graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        }
        return new GLCanvas(GLContextFactory.getFactory().chooseGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser, graphicsDevice), gLCapabilities, gLCapabilitiesChooser, gLDrawable);
    }

    public GLJPanel createGLJPanel(GLCapabilities gLCapabilities) {
        return this.createGLJPanel(gLCapabilities, null, null);
    }

    public GLJPanel createGLJPanel(GLCapabilities gLCapabilities, GLDrawable gLDrawable) {
        return this.createGLJPanel(gLCapabilities, null, gLDrawable);
    }

    public GLJPanel createGLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser) {
        return this.createGLJPanel(gLCapabilities, gLCapabilitiesChooser, null);
    }

    public GLJPanel createGLJPanel(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLDrawable gLDrawable) {
        if (gLCapabilitiesChooser == null) {
            gLCapabilitiesChooser = new DefaultGLCapabilitiesChooser();
        }
        return new GLJPanel(gLCapabilities, gLCapabilitiesChooser, gLDrawable);
    }
}

