/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.util;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLException;
import net.java.games.jogl.GLU;
import net.java.games.jogl.GLUquadric;
import net.java.games.jogl.util.BitmapCharRec;
import net.java.games.jogl.util.BitmapFontRec;
import net.java.games.jogl.util.CoordRec;
import net.java.games.jogl.util.GLUTBitmap8x13;
import net.java.games.jogl.util.GLUTBitmap9x15;
import net.java.games.jogl.util.GLUTBitmapHelvetica10;
import net.java.games.jogl.util.GLUTBitmapHelvetica12;
import net.java.games.jogl.util.GLUTBitmapHelvetica18;
import net.java.games.jogl.util.GLUTBitmapTimesRoman10;
import net.java.games.jogl.util.GLUTBitmapTimesRoman24;
import net.java.games.jogl.util.GLUTStrokeMonoRoman;
import net.java.games.jogl.util.GLUTStrokeRoman;
import net.java.games.jogl.util.StrokeCharRec;
import net.java.games.jogl.util.StrokeFontRec;
import net.java.games.jogl.util.StrokeRec;

public class GLUT {
    public static final int STROKE_ROMAN = 0;
    public static final int STROKE_MONO_ROMAN = 1;
    public static final int BITMAP_9_BY_15 = 2;
    public static final int BITMAP_8_BY_13 = 3;
    public static final int BITMAP_TIMES_ROMAN_10 = 4;
    public static final int BITMAP_TIMES_ROMAN_24 = 5;
    public static final int BITMAP_HELVETICA_10 = 6;
    public static final int BITMAP_HELVETICA_12 = 7;
    public static final int BITMAP_HELVETICA_18 = 8;
    private GLUquadric quadObj;
    private static float[][] boxVertices;
    private static final float[][] boxNormals;
    private static final int[][] boxFaces;
    private float[][] dodec;
    private static final float[][] odata;
    private static final int[][] ondex;
    private static final float X = 0.5257311f;
    private static final float Z = 0.8506508f;
    private static final float[][] idata;
    private static final int[][] index;
    private static final float T = 1.7320508f;
    private static final float[][] tdata;
    private static final int[][] tndex;
    private static final int[][] teapotPatchData;
    private static final float[][] teapotCPData;
    private static final float[] teapotTex;
    private static final BitmapFontRec[] bitmapFonts;
    private static final StrokeFontRec[] strokeFonts;

    public void glutWireSphere(GLU gLU, double d, int n, int n2) {
        this.quadObjInit(gLU);
        gLU.gluQuadricDrawStyle(this.quadObj, 100011);
        gLU.gluQuadricNormals(this.quadObj, 100000);
        gLU.gluSphere(this.quadObj, d, n, n2);
    }

    public void glutSolidSphere(GLU gLU, double d, int n, int n2) {
        this.quadObjInit(gLU);
        gLU.gluQuadricDrawStyle(this.quadObj, 100012);
        gLU.gluQuadricNormals(this.quadObj, 100000);
        gLU.gluSphere(this.quadObj, d, n, n2);
    }

    public void glutWireCone(GLU gLU, double d, double d2, int n, int n2) {
        this.quadObjInit(gLU);
        gLU.gluQuadricDrawStyle(this.quadObj, 100011);
        gLU.gluQuadricNormals(this.quadObj, 100000);
        gLU.gluCylinder(this.quadObj, d, 0.0, d2, n, n2);
    }

    public void glutSolidCone(GLU gLU, double d, double d2, int n, int n2) {
        this.quadObjInit(gLU);
        gLU.gluQuadricDrawStyle(this.quadObj, 100012);
        gLU.gluQuadricNormals(this.quadObj, 100000);
        gLU.gluCylinder(this.quadObj, d, 0.0, d2, n, n2);
    }

    public void glutWireCube(GL gL, float f) {
        this.drawBox(gL, f, 2);
    }

    public void glutSolidCube(GL gL, float f) {
        this.drawBox(gL, f, 7);
    }

    public void glutWireTorus(GL gL, double d, double d2, int n, int n2) {
        gL.glPushAttrib(8);
        gL.glPolygonMode(1032, 6913);
        GLUT.doughnut(gL, d, d2, n, n2);
        gL.glPopAttrib();
    }

    public void glutSolidTorus(GL gL, double d, double d2, int n, int n2) {
        GLUT.doughnut(gL, d, d2, n, n2);
    }

    public void glutWireDodecahedron(GL gL) {
        this.dodecahedron(gL, 2);
    }

    public void glutSolidDodecahedron(GL gL) {
        this.dodecahedron(gL, 6);
    }

    public void glutWireOctahedron(GL gL) {
        GLUT.octahedron(gL, 2);
    }

    public void glutSolidOctahedron(GL gL) {
        GLUT.octahedron(gL, 4);
    }

    public void glutWireIcosahedron(GL gL) {
        GLUT.icosahedron(gL, 2);
    }

    public void glutSolidIcosahedron(GL gL) {
        GLUT.icosahedron(gL, 4);
    }

    public void glutWireTetrahedron(GL gL) {
        GLUT.tetrahedron(gL, 2);
    }

    public void glutSolidTetrahedron(GL gL) {
        GLUT.tetrahedron(gL, 4);
    }

    public void glutSolidTeapot(GL gL, double d) {
        this.glutSolidTeapot(gL, d, true);
    }

    public void glutSolidTeapot(GL gL, double d, boolean bl) {
        GLUT.teapot(gL, 14, d, 6914, bl);
    }

    public void glutWireTeapot(GL gL, double d) {
        this.glutWireTeapot(gL, d, true);
    }

    public void glutWireTeapot(GL gL, double d, boolean bl) {
        GLUT.teapot(gL, 10, d, 6913, bl);
    }

    public void glutBitmapCharacter(GL gL, int n, char c) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        GLUT.beginBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
        GLUT.bitmapCharacterImpl(gL, n, c);
        GLUT.endBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
    }

    public void glutBitmapString(GL gL, int n, String string) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        GLUT.beginBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            GLUT.bitmapCharacterImpl(gL, n, string.charAt(i));
        }
        GLUT.endBitmap(gL, nArray, nArray2, nArray3, nArray4, nArray5, nArray6);
    }

    public int glutBitmapWidth(int n, char c) {
        BitmapFontRec bitmapFontRec = GLUT.getBitmapFont(n);
        int n2 = c & 0xFFFF;
        if (n2 < bitmapFontRec.first || n2 >= bitmapFontRec.first + bitmapFontRec.num_chars) {
            return 0;
        }
        BitmapCharRec bitmapCharRec = bitmapFontRec.ch[n2 - bitmapFontRec.first];
        if (bitmapCharRec != null) {
            return (int)bitmapCharRec.advance;
        }
        return 0;
    }

    public void glutStrokeCharacter(GL gL, int n, char c) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n);
        int n2 = c & 0xFFFF;
        if (n2 < 0 || n2 >= strokeFontRec.num_chars) {
            return;
        }
        StrokeCharRec strokeCharRec = strokeFontRec.ch[n2];
        if (strokeCharRec != null) {
            for (int i = 0; i < strokeCharRec.num_strokes; ++i) {
                StrokeRec strokeRec = strokeCharRec.stroke[i];
                gL.glBegin(3);
                for (int j = 0; j < strokeRec.num_coords; ++j) {
                    CoordRec coordRec = strokeRec.coord[j];
                    gL.glVertex2f(coordRec.x, coordRec.y);
                }
                gL.glEnd();
            }
            gL.glTranslatef(strokeCharRec.right, 0.0f, 0.0f);
        }
    }

    public void glutStrokeString(GL gL, int n, String string) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            StrokeCharRec strokeCharRec;
            int n3 = string.charAt(i) & 0xFFFF;
            if (n3 < 0 || n3 >= strokeFontRec.num_chars || (strokeCharRec = strokeFontRec.ch[n3]) == null) continue;
            for (int j = 0; j < strokeCharRec.num_strokes; ++j) {
                StrokeRec strokeRec = strokeCharRec.stroke[j];
                gL.glBegin(3);
                for (int k = 0; k < strokeRec.num_coords; ++k) {
                    CoordRec coordRec = strokeRec.coord[k];
                    gL.glVertex2f(coordRec.x, coordRec.y);
                }
                gL.glEnd();
            }
            gL.glTranslatef(strokeCharRec.right, 0.0f, 0.0f);
        }
    }

    public int glutStrokeWidth(int n, char c) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n);
        int n2 = c & 0xFFFF;
        if (n2 < 0 || n2 >= strokeFontRec.num_chars) {
            return 0;
        }
        StrokeCharRec strokeCharRec = strokeFontRec.ch[n2];
        if (strokeCharRec != null) {
            return (int)strokeCharRec.right;
        }
        return 0;
    }

    public int glutBitmapLength(int n, String string) {
        BitmapFontRec bitmapFontRec = GLUT.getBitmapFont(n);
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            BitmapCharRec bitmapCharRec;
            int n4 = string.charAt(i) & 0xFFFF;
            if (n4 < bitmapFontRec.first || n4 >= bitmapFontRec.first + bitmapFontRec.num_chars || (bitmapCharRec = bitmapFontRec.ch[n4 - bitmapFontRec.first]) == null) continue;
            n2 = (int)((float)n2 + bitmapCharRec.advance);
        }
        return n2;
    }

    public int glutStrokeLength(int n, String string) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n);
        float f = 0.0f;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            StrokeCharRec strokeCharRec;
            char c = string.charAt(i);
            if (c < '\u0000' || c >= strokeFontRec.num_chars || (strokeCharRec = strokeFontRec.ch[c]) == null) continue;
            f += strokeCharRec.right;
        }
        return (int)f;
    }

    public float glutStrokeLengthf(int n, String string) {
        StrokeFontRec strokeFontRec = GLUT.getStrokeFont(n);
        float f = 0.0f;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            StrokeCharRec strokeCharRec;
            char c = string.charAt(i);
            if (c < '\u0000' || c >= strokeFontRec.num_chars || (strokeCharRec = strokeFontRec.ch[c]) == null) continue;
            f += strokeCharRec.right;
        }
        return f;
    }

    private void quadObjInit(GLU gLU) {
        if (this.quadObj == null) {
            this.quadObj = gLU.gluNewQuadric();
        }
        if (this.quadObj == null) {
            throw new GLException("Out of memory");
        }
    }

    private static void doughnut(GL gL, double d, double d2, int n, int n2) {
        float f = (float)(Math.PI * 2 / (double)n2);
        float f2 = (float)(Math.PI * 2 / (double)n);
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5 = 0.0f;
        for (int i = n2 - 1; i >= 0; --i) {
            float f6 = f3 + f;
            float f7 = (float)Math.cos(f6);
            float f8 = (float)Math.sin(f6);
            gL.glBegin(8);
            float f9 = 0.0f;
            for (int j = n; j >= 0; --j) {
                float f10 = (float)Math.cos(f9 += f2);
                float f11 = (float)Math.sin(f9);
                float f12 = (float)(d2 + d * (double)f10);
                gL.glNormal3f(f7 * f10, -f8 * f10, f11);
                gL.glVertex3f(f7 * f12, -f8 * f12, (float)d * f11);
                gL.glNormal3f(f4 * f10, -f5 * f10, f11);
                gL.glVertex3f(f4 * f12, -f5 * f12, (float)d * f11);
            }
            gL.glEnd();
            f3 = f6;
            f4 = f7;
            f5 = f8;
        }
    }

    private void drawBox(GL gL, float f, int n) {
        Object object;
        if (boxVertices == null) {
            object = new float[8][];
            for (int i = 0; i < 8; ++i) {
                object[i] = new float[3];
            }
            object[3][0] = -0.5f;
            object[2][0] = -0.5f;
            object[1][0] = -0.5f;
            object[0][0] = -0.5f;
            object[7][0] = 0.5f;
            object[6][0] = 0.5f;
            object[5][0] = 0.5f;
            object[4][0] = 0.5f;
            object[5][1] = -0.5f;
            object[4][1] = -0.5f;
            object[1][1] = -0.5f;
            object[0][1] = -0.5f;
            object[7][1] = 0.5f;
            object[6][1] = 0.5f;
            object[3][1] = 0.5f;
            object[2][1] = 0.5f;
            object[7][2] = -0.5f;
            object[4][2] = -0.5f;
            object[3][2] = -0.5f;
            object[0][2] = -0.5f;
            object[6][2] = 0.5f;
            object[5][2] = 0.5f;
            object[2][2] = 0.5f;
            object[1][2] = 0.5f;
            boxVertices = object;
        }
        object = boxVertices;
        float[][] fArray = boxNormals;
        int[][] nArray = boxFaces;
        for (int i = 5; i >= 0; --i) {
            gL.glBegin(n);
            gL.glNormal3fv(fArray[i]);
            float[] fArray2 = object[nArray[i][0]];
            gL.glVertex3f(fArray2[0] * f, fArray2[1] * f, fArray2[2] * f);
            fArray2 = object[nArray[i][1]];
            gL.glVertex3f(fArray2[0] * f, fArray2[1] * f, fArray2[2] * f);
            fArray2 = object[nArray[i][2]];
            gL.glVertex3f(fArray2[0] * f, fArray2[1] * f, fArray2[2] * f);
            fArray2 = object[nArray[i][3]];
            gL.glVertex3f(fArray2[0] * f, fArray2[1] * f, fArray2[2] * f);
            gL.glEnd();
        }
    }

    private void initDodecahedron() {
        this.dodec = new float[20][];
        for (int i = 0; i < this.dodec.length; ++i) {
            this.dodec[i] = new float[3];
        }
        float f = (float)Math.sqrt(2.0 / (3.0 + Math.sqrt(5.0)));
        float f2 = 1.0f + (float)Math.sqrt(6.0 / (3.0 + Math.sqrt(5.0)) - 2.0 + 2.0 * Math.sqrt(2.0 / (3.0 + Math.sqrt(5.0))));
        this.dodec[0][0] = -f;
        this.dodec[0][1] = 0.0f;
        this.dodec[0][2] = f2;
        this.dodec[1][0] = f;
        this.dodec[1][1] = 0.0f;
        this.dodec[1][2] = f2;
        this.dodec[2][0] = -1.0f;
        this.dodec[2][1] = -1.0f;
        this.dodec[2][2] = -1.0f;
        this.dodec[3][0] = -1.0f;
        this.dodec[3][1] = -1.0f;
        this.dodec[3][2] = 1.0f;
        this.dodec[4][0] = -1.0f;
        this.dodec[4][1] = 1.0f;
        this.dodec[4][2] = -1.0f;
        this.dodec[5][0] = -1.0f;
        this.dodec[5][1] = 1.0f;
        this.dodec[5][2] = 1.0f;
        this.dodec[6][0] = 1.0f;
        this.dodec[6][1] = -1.0f;
        this.dodec[6][2] = -1.0f;
        this.dodec[7][0] = 1.0f;
        this.dodec[7][1] = -1.0f;
        this.dodec[7][2] = 1.0f;
        this.dodec[8][0] = 1.0f;
        this.dodec[8][1] = 1.0f;
        this.dodec[8][2] = -1.0f;
        this.dodec[9][0] = 1.0f;
        this.dodec[9][1] = 1.0f;
        this.dodec[9][2] = 1.0f;
        this.dodec[10][0] = f2;
        this.dodec[10][1] = f;
        this.dodec[10][2] = 0.0f;
        this.dodec[11][0] = f2;
        this.dodec[11][1] = -f;
        this.dodec[11][2] = 0.0f;
        this.dodec[12][0] = -f2;
        this.dodec[12][1] = f;
        this.dodec[12][2] = 0.0f;
        this.dodec[13][0] = -f2;
        this.dodec[13][1] = -f;
        this.dodec[13][2] = 0.0f;
        this.dodec[14][0] = -f;
        this.dodec[14][1] = 0.0f;
        this.dodec[14][2] = -f2;
        this.dodec[15][0] = f;
        this.dodec[15][1] = 0.0f;
        this.dodec[15][2] = -f2;
        this.dodec[16][0] = 0.0f;
        this.dodec[16][1] = f2;
        this.dodec[16][2] = f;
        this.dodec[17][0] = 0.0f;
        this.dodec[17][1] = f2;
        this.dodec[17][2] = -f;
        this.dodec[18][0] = 0.0f;
        this.dodec[18][1] = -f2;
        this.dodec[18][2] = f;
        this.dodec[19][0] = 0.0f;
        this.dodec[19][1] = -f2;
        this.dodec[19][2] = -f;
    }

    private static void diff3(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray3[0] = fArray[0] - fArray2[0];
        fArray3[1] = fArray[1] - fArray2[1];
        fArray3[2] = fArray[2] - fArray2[2];
    }

    private static void crossprod(float[] fArray, float[] fArray2, float[] fArray3) {
        float[] fArray4 = new float[]{fArray[1] * fArray2[2] - fArray2[1] * fArray[2], fArray[2] * fArray2[0] - fArray2[2] * fArray[0], fArray[0] * fArray2[1] - fArray2[0] * fArray[1]};
        fArray3[0] = fArray4[0];
        fArray3[1] = fArray4[1];
        fArray3[2] = fArray4[2];
    }

    private static void normalize(float[] fArray) {
        float f = (float)Math.sqrt(fArray[0] * fArray[0] + fArray[1] * fArray[1] + fArray[2] * fArray[2]);
        if ((double)f == 0.0) {
            f = 1.0f;
            fArray[0] = 1.0f;
        }
        f = 1.0f / f;
        fArray[0] = fArray[0] * f;
        fArray[1] = fArray[1] * f;
        fArray[2] = fArray[2] * f;
    }

    private void pentagon(GL gL, int n, int n2, int n3, int n4, int n5, int n6) {
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        GLUT.diff3(this.dodec[n], this.dodec[n2], fArray2);
        GLUT.diff3(this.dodec[n2], this.dodec[n3], fArray3);
        GLUT.crossprod(fArray2, fArray3, fArray);
        GLUT.normalize(fArray);
        gL.glBegin(n6);
        gL.glNormal3fv(fArray);
        gL.glVertex3fv(this.dodec[n]);
        gL.glVertex3fv(this.dodec[n2]);
        gL.glVertex3fv(this.dodec[n3]);
        gL.glVertex3fv(this.dodec[n4]);
        gL.glVertex3fv(this.dodec[n5]);
        gL.glEnd();
    }

    private void dodecahedron(GL gL, int n) {
        if (this.dodec == null) {
            this.initDodecahedron();
        }
        this.pentagon(gL, 0, 1, 9, 16, 5, n);
        this.pentagon(gL, 1, 0, 3, 18, 7, n);
        this.pentagon(gL, 1, 7, 11, 10, 9, n);
        this.pentagon(gL, 11, 7, 18, 19, 6, n);
        this.pentagon(gL, 8, 17, 16, 9, 10, n);
        this.pentagon(gL, 2, 14, 15, 6, 19, n);
        this.pentagon(gL, 2, 13, 12, 4, 14, n);
        this.pentagon(gL, 2, 19, 18, 3, 13, n);
        this.pentagon(gL, 3, 0, 5, 12, 13, n);
        this.pentagon(gL, 6, 15, 8, 10, 11, n);
        this.pentagon(gL, 4, 17, 8, 15, 14, n);
        this.pentagon(gL, 4, 12, 5, 16, 17, n);
    }

    private static void recorditem(GL gL, float[] fArray, float[] fArray2, float[] fArray3, int n) {
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        GLUT.diff3(fArray, fArray2, fArray4);
        GLUT.diff3(fArray2, fArray3, fArray5);
        GLUT.crossprod(fArray4, fArray5, fArray5);
        GLUT.normalize(fArray5);
        gL.glBegin(n);
        gL.glNormal3fv(fArray5);
        gL.glVertex3fv(fArray);
        gL.glVertex3fv(fArray2);
        gL.glVertex3fv(fArray3);
        gL.glEnd();
    }

    private static void subdivide(GL gL, float[] fArray, float[] fArray2, float[] fArray3, int n) {
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        int n2 = 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            while (i + n3 < n2) {
                int n4 = n2 - i - n3;
                for (int j = 0; j < 3; ++j) {
                    fArray4[j] = ((float)i * fArray[j] + (float)n3 * fArray2[j] + (float)n4 * fArray3[j]) / (float)n2;
                    fArray5[j] = ((float)(i + 1) * fArray[j] + (float)n3 * fArray2[j] + (float)(n4 - 1) * fArray3[j]) / (float)n2;
                    fArray6[j] = ((float)i * fArray[j] + (float)(n3 + 1) * fArray2[j] + (float)(n4 - 1) * fArray3[j]) / (float)n2;
                }
                float f = (float)Math.sqrt(fArray4[0] * fArray4[0] + fArray4[1] * fArray4[1] + fArray4[2] * fArray4[2]);
                fArray4[0] = fArray4[0] / f;
                fArray4[1] = fArray4[1] / f;
                fArray4[2] = fArray4[2] / f;
                f = (float)Math.sqrt(fArray5[0] * fArray5[0] + fArray5[1] * fArray5[1] + fArray5[2] * fArray5[2]);
                fArray5[0] = fArray5[0] / f;
                fArray5[1] = fArray5[1] / f;
                fArray5[2] = fArray5[2] / f;
                f = (float)Math.sqrt(fArray6[0] * fArray6[0] + fArray6[1] * fArray6[1] + fArray6[2] * fArray6[2]);
                fArray6[0] = fArray6[0] / f;
                fArray6[1] = fArray6[1] / f;
                fArray6[2] = fArray6[2] / f;
                GLUT.recorditem(gL, fArray5, fArray4, fArray6, n);
                ++n3;
            }
        }
    }

    private static void drawtriangle(GL gL, int n, float[][] fArray, int[][] nArray, int n2) {
        float[] fArray2 = fArray[nArray[n][0]];
        float[] fArray3 = fArray[nArray[n][1]];
        float[] fArray4 = fArray[nArray[n][2]];
        GLUT.subdivide(gL, fArray2, fArray3, fArray4, n2);
    }

    private static void octahedron(GL gL, int n) {
        for (int i = 7; i >= 0; --i) {
            GLUT.drawtriangle(gL, i, odata, ondex, n);
        }
    }

    private static void icosahedron(GL gL, int n) {
        for (int i = 19; i >= 0; --i) {
            GLUT.drawtriangle(gL, i, idata, index, n);
        }
    }

    private static final void tetrahedron(GL gL, int n) {
        for (int i = 3; i >= 0; --i) {
            GLUT.drawtriangle(gL, i, tdata, tndex, n);
        }
    }

    private static void teapot(GL gL, int n, double d, int n2, boolean bl) {
        float[] fArray = new float[48];
        float[] fArray2 = new float[48];
        float[] fArray3 = new float[48];
        float[] fArray4 = new float[48];
        gL.glPushAttrib(73736);
        gL.glEnable(3456);
        gL.glEnable(2977);
        gL.glEnable(3511);
        gL.glEnable(3508);
        if (!bl) {
            gL.glFrontFace(2304);
            gL.glScaled(0.5 * d, 0.5 * d, 0.5 * d);
        } else {
            gL.glPushMatrix();
            gL.glRotatef(270.0f, 1.0f, 0.0f, 0.0f);
            gL.glScalef((float)(0.5 * d), (float)(0.5 * d), (float)(0.5 * d));
            gL.glTranslatef(0.0f, 0.0f, -1.5f);
        }
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    for (int i2 = 0; i2 < 3; ++i2) {
                        fArray[(j * 4 + k) * 3 + i2] = teapotCPData[teapotPatchData[i][j * 4 + k]][i2];
                        fArray2[(j * 4 + k) * 3 + i2] = teapotCPData[teapotPatchData[i][j * 4 + (3 - k)]][i2];
                        if (i2 == 1) {
                            int n3 = (j * 4 + k) * 3 + i2;
                            fArray2[n3] = (float)((double)fArray2[n3] * -1.0);
                        }
                        if (i >= 6) continue;
                        fArray3[(j * 4 + k) * 3 + i2] = teapotCPData[teapotPatchData[i][j * 4 + (3 - k)]][i2];
                        if (i2 == 0) {
                            int n4 = (j * 4 + k) * 3 + i2;
                            fArray3[n4] = (float)((double)fArray3[n4] * -1.0);
                        }
                        fArray4[(j * 4 + k) * 3 + i2] = teapotCPData[teapotPatchData[i][j * 4 + k]][i2];
                        if (i2 == 0) {
                            int n5 = (j * 4 + k) * 3 + i2;
                            fArray4[n5] = (float)((double)fArray4[n5] * -1.0);
                        }
                        if (i2 != 1) continue;
                        int n6 = (j * 4 + k) * 3 + i2;
                        fArray4[n6] = (float)((double)fArray4[n6] * -1.0);
                    }
                }
            }
            gL.glMap2f(3508, 0.0f, 1.0f, 2, 2, 0.0f, 1.0f, 4, 2, teapotTex);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray);
            gL.glMapGrid2f(n, 0.0f, 1.0f, n, 0.0f, 1.0f);
            GLUT.evaluateTeapotMesh(gL, n, n2, i, !bl);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray2);
            GLUT.evaluateTeapotMesh(gL, n, n2, i, !bl);
            if (i >= 6) continue;
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray3);
            GLUT.evaluateTeapotMesh(gL, n, n2, i, !bl);
            gL.glMap2f(3511, 0.0f, 1.0f, 3, 4, 0.0f, 1.0f, 12, 4, fArray4);
            GLUT.evaluateTeapotMesh(gL, n, n2, i, !bl);
        }
        if (bl) {
            gL.glPopMatrix();
        }
        gL.glPopAttrib();
    }

    private static void evaluateTeapotMesh(GL gL, int n, int n2, int n3, boolean bl) {
        if (bl && (n3 == 5 || n3 == 3)) {
            gL.glPolygonMode(1032, n2);
            for (int i = 0; i < n; ++i) {
                int n4;
                if (i == 0) {
                    gL.glDisable(3456);
                    gL.glNormal3f(0.0f, 0.0f, n3 == 3 ? 1.0f : -1.0f);
                    gL.glBegin(6);
                    gL.glEvalCoord2f(0.0f, 0.0f);
                    for (n4 = 0; n4 <= n; ++n4) {
                        gL.glEvalCoord2f((float)n4 / (float)n, 1.0f / (float)n / (float)n);
                    }
                    gL.glEnd();
                    gL.glEnable(3456);
                }
                gL.glBegin(8);
                for (n4 = n; n4 >= 0; --n4) {
                    gL.glEvalCoord2f((float)n4 / (float)n, (float)(i + 1) / (float)n);
                    gL.glEvalCoord2f((float)n4 / (float)n, Math.max((float)i, 1.0f / (float)n) / (float)n);
                }
                gL.glEnd();
            }
        } else {
            gL.glEvalMesh2(n2, 0, n, 0, n);
        }
    }

    private static void bitmapCharacterImpl(GL gL, int n, char c) {
        BitmapFontRec bitmapFontRec = GLUT.getBitmapFont(n);
        int n2 = c & 0xFFFF;
        if (n2 < bitmapFontRec.first || n2 >= bitmapFontRec.first + bitmapFontRec.num_chars) {
            return;
        }
        BitmapCharRec bitmapCharRec = bitmapFontRec.ch[n2 - bitmapFontRec.first];
        if (bitmapCharRec != null) {
            gL.glBitmap(bitmapCharRec.width, bitmapCharRec.height, bitmapCharRec.xorig, bitmapCharRec.yorig, bitmapCharRec.advance, 0.0f, bitmapCharRec.bitmap);
        }
    }

    private static BitmapFontRec getBitmapFont(int n) {
        BitmapFontRec bitmapFontRec = bitmapFonts[n];
        if (bitmapFontRec == null) {
            switch (n) {
                case 2: {
                    bitmapFontRec = GLUTBitmap9x15.glutBitmap9By15;
                    break;
                }
                case 3: {
                    bitmapFontRec = GLUTBitmap8x13.glutBitmap8By13;
                    break;
                }
                case 4: {
                    bitmapFontRec = GLUTBitmapTimesRoman10.glutBitmapTimesRoman10;
                    break;
                }
                case 5: {
                    bitmapFontRec = GLUTBitmapTimesRoman24.glutBitmapTimesRoman24;
                    break;
                }
                case 6: {
                    bitmapFontRec = GLUTBitmapHelvetica10.glutBitmapHelvetica10;
                    break;
                }
                case 7: {
                    bitmapFontRec = GLUTBitmapHelvetica12.glutBitmapHelvetica12;
                    break;
                }
                case 8: {
                    bitmapFontRec = GLUTBitmapHelvetica18.glutBitmapHelvetica18;
                    break;
                }
                default: {
                    throw new GLException("Unknown bitmap font number " + n);
                }
            }
            GLUT.bitmapFonts[n] = bitmapFontRec;
        }
        return bitmapFontRec;
    }

    private static StrokeFontRec getStrokeFont(int n) {
        StrokeFontRec strokeFontRec = strokeFonts[n];
        if (strokeFontRec == null) {
            switch (n) {
                case 0: {
                    strokeFontRec = GLUTStrokeRoman.glutStrokeRoman;
                    break;
                }
                case 1: {
                    strokeFontRec = GLUTStrokeMonoRoman.glutStrokeMonoRoman;
                    break;
                }
                default: {
                    throw new GLException("Unknown stroke font number " + n);
                }
            }
        }
        return strokeFontRec;
    }

    private static void beginBitmap(GL gL, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        gL.glGetIntegerv(3312, nArray);
        gL.glGetIntegerv(3313, nArray2);
        gL.glGetIntegerv(3314, nArray3);
        gL.glGetIntegerv(3315, nArray4);
        gL.glGetIntegerv(3316, nArray5);
        gL.glGetIntegerv(3317, nArray6);
        gL.glPixelStorei(3312, 0);
        gL.glPixelStorei(3313, 0);
        gL.glPixelStorei(3314, 0);
        gL.glPixelStorei(3315, 0);
        gL.glPixelStorei(3316, 0);
        gL.glPixelStorei(3317, 1);
    }

    private static void endBitmap(GL gL, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        gL.glPixelStorei(3312, nArray[0]);
        gL.glPixelStorei(3313, nArray2[0]);
        gL.glPixelStorei(3314, nArray3[0]);
        gL.glPixelStorei(3315, nArray4[0]);
        gL.glPixelStorei(3316, nArray5[0]);
        gL.glPixelStorei(3317, nArray6[0]);
    }

    static {
        boxNormals = new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        boxFaces = new int[][]{{0, 1, 2, 3}, {3, 2, 6, 7}, {7, 6, 5, 4}, {4, 5, 1, 0}, {5, 6, 2, 1}, {7, 4, 0, 3}};
        odata = new float[][]{{1.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, -1.0f}};
        ondex = new int[][]{{0, 4, 2}, {1, 2, 4}, {0, 3, 4}, {1, 4, 3}, {0, 2, 5}, {1, 5, 2}, {0, 5, 3}, {1, 3, 5}};
        idata = new float[][]{{-0.5257311f, 0.0f, 0.8506508f}, {0.5257311f, 0.0f, 0.8506508f}, {-0.5257311f, 0.0f, -0.8506508f}, {0.5257311f, 0.0f, -0.8506508f}, {0.0f, 0.8506508f, 0.5257311f}, {0.0f, 0.8506508f, -0.5257311f}, {0.0f, -0.8506508f, 0.5257311f}, {0.0f, -0.8506508f, -0.5257311f}, {0.8506508f, 0.5257311f, 0.0f}, {-0.8506508f, 0.5257311f, 0.0f}, {0.8506508f, -0.5257311f, 0.0f}, {-0.8506508f, -0.5257311f, 0.0f}};
        index = new int[][]{{0, 4, 1}, {0, 9, 4}, {9, 5, 4}, {4, 5, 8}, {4, 8, 1}, {8, 10, 1}, {8, 3, 10}, {5, 3, 8}, {5, 2, 3}, {2, 7, 3}, {7, 10, 3}, {7, 6, 10}, {7, 11, 6}, {11, 0, 6}, {0, 1, 6}, {6, 1, 10}, {9, 0, 11}, {9, 11, 2}, {9, 2, 5}, {7, 2, 11}};
        tdata = new float[][]{{1.7320508f, 1.7320508f, 1.7320508f}, {1.7320508f, -1.7320508f, -1.7320508f}, {-1.7320508f, 1.7320508f, -1.7320508f}, {-1.7320508f, -1.7320508f, 1.7320508f}};
        tndex = new int[][]{{0, 1, 3}, {2, 1, 0}, {3, 2, 0}, {1, 2, 3}};
        teapotPatchData = new int[][]{{102, 103, 104, 105, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27}, {24, 25, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40}, {96, 96, 96, 96, 97, 98, 99, 100, 101, 101, 101, 101, 0, 1, 2, 3}, {0, 1, 2, 3, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117}, {118, 118, 118, 118, 124, 122, 119, 121, 123, 126, 125, 120, 40, 39, 38, 37}, {41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56}, {53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 28, 65, 66, 67}, {68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83}, {80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95}};
        teapotCPData = new float[][]{{0.2f, 0.0f, 2.7f}, {0.2f, -0.112f, 2.7f}, {0.112f, -0.2f, 2.7f}, {0.0f, -0.2f, 2.7f}, {1.3375f, 0.0f, 2.53125f}, {1.3375f, -0.749f, 2.53125f}, {0.749f, -1.3375f, 2.53125f}, {0.0f, -1.3375f, 2.53125f}, {1.4375f, 0.0f, 2.53125f}, {1.4375f, -0.805f, 2.53125f}, {0.805f, -1.4375f, 2.53125f}, {0.0f, -1.4375f, 2.53125f}, {1.5f, 0.0f, 2.4f}, {1.5f, -0.84f, 2.4f}, {0.84f, -1.5f, 2.4f}, {0.0f, -1.5f, 2.4f}, {1.75f, 0.0f, 1.875f}, {1.75f, -0.98f, 1.875f}, {0.98f, -1.75f, 1.875f}, {0.0f, -1.75f, 1.875f}, {2.0f, 0.0f, 1.35f}, {2.0f, -1.12f, 1.35f}, {1.12f, -2.0f, 1.35f}, {0.0f, -2.0f, 1.35f}, {2.0f, 0.0f, 0.9f}, {2.0f, -1.12f, 0.9f}, {1.12f, -2.0f, 0.9f}, {0.0f, -2.0f, 0.9f}, {-2.0f, 0.0f, 0.9f}, {2.0f, 0.0f, 0.45f}, {2.0f, -1.12f, 0.45f}, {1.12f, -2.0f, 0.45f}, {0.0f, -2.0f, 0.45f}, {1.5f, 0.0f, 0.225f}, {1.5f, -0.84f, 0.225f}, {0.84f, -1.5f, 0.225f}, {0.0f, -1.5f, 0.225f}, {1.5f, 0.0f, 0.15f}, {1.5f, -0.84f, 0.15f}, {0.84f, -1.5f, 0.15f}, {0.0f, -1.5f, 0.15f}, {-1.6f, 0.0f, 2.025f}, {-1.6f, -0.3f, 2.025f}, {-1.5f, -0.3f, 2.25f}, {-1.5f, 0.0f, 2.25f}, {-2.3f, 0.0f, 2.025f}, {-2.3f, -0.3f, 2.025f}, {-2.5f, -0.3f, 2.25f}, {-2.5f, 0.0f, 2.25f}, {-2.7f, 0.0f, 2.025f}, {-2.7f, -0.3f, 2.025f}, {-3.0f, -0.3f, 2.25f}, {-3.0f, 0.0f, 2.25f}, {-2.7f, 0.0f, 1.8f}, {-2.7f, -0.3f, 1.8f}, {-3.0f, -0.3f, 1.8f}, {-3.0f, 0.0f, 1.8f}, {-2.7f, 0.0f, 1.575f}, {-2.7f, -0.3f, 1.575f}, {-3.0f, -0.3f, 1.35f}, {-3.0f, 0.0f, 1.35f}, {-2.5f, 0.0f, 1.125f}, {-2.5f, -0.3f, 1.125f}, {-2.65f, -0.3f, 0.9375f}, {-2.65f, 0.0f, 0.9375f}, {-2.0f, -0.3f, 0.9f}, {-1.9f, -0.3f, 0.6f}, {-1.9f, 0.0f, 0.6f}, {1.7f, 0.0f, 1.425f}, {1.7f, -0.66f, 1.425f}, {1.7f, -0.66f, 0.6f}, {1.7f, 0.0f, 0.6f}, {2.6f, 0.0f, 1.425f}, {2.6f, -0.66f, 1.425f}, {3.1f, -0.66f, 0.825f}, {3.1f, 0.0f, 0.825f}, {2.3f, 0.0f, 2.1f}, {2.3f, -0.25f, 2.1f}, {2.4f, -0.25f, 2.025f}, {2.4f, 0.0f, 2.025f}, {2.7f, 0.0f, 2.4f}, {2.7f, -0.25f, 2.4f}, {3.3f, -0.25f, 2.4f}, {3.3f, 0.0f, 2.4f}, {2.8f, 0.0f, 2.475f}, {2.8f, -0.25f, 2.475f}, {3.525f, -0.25f, 2.49375f}, {3.525f, 0.0f, 2.49375f}, {2.9f, 0.0f, 2.475f}, {2.9f, -0.15f, 2.475f}, {3.45f, -0.15f, 2.5125f}, {3.45f, 0.0f, 2.5125f}, {2.8f, 0.0f, 2.4f}, {2.8f, -0.15f, 2.4f}, {3.2f, -0.15f, 2.4f}, {3.2f, 0.0f, 2.4f}, {0.0f, 0.0f, 3.15f}, {0.8f, 0.0f, 3.15f}, {0.8f, -0.45f, 3.15f}, {0.45f, -0.8f, 3.15f}, {0.0f, -0.8f, 3.15f}, {0.0f, 0.0f, 2.85f}, {1.4f, 0.0f, 2.4f}, {1.4f, -0.784f, 2.4f}, {0.784f, -1.4f, 2.4f}, {0.0f, -1.4f, 2.4f}, {0.4f, 0.0f, 2.55f}, {0.4f, -0.224f, 2.55f}, {0.224f, -0.4f, 2.55f}, {0.0f, -0.4f, 2.55f}, {1.3f, 0.0f, 2.55f}, {1.3f, -0.728f, 2.55f}, {0.728f, -1.3f, 2.55f}, {0.0f, -1.3f, 2.55f}, {1.3f, 0.0f, 2.4f}, {1.3f, -0.728f, 2.4f}, {0.728f, -1.3f, 2.4f}, {0.0f, -1.3f, 2.4f}, {0.0f, 0.0f, 0.0f}, {1.425f, -0.798f, 0.0f}, {1.5f, 0.0f, 0.075f}, {1.425f, 0.0f, 0.0f}, {0.798f, -1.425f, 0.0f}, {0.0f, -1.5f, 0.075f}, {0.0f, -1.425f, 0.0f}, {1.5f, -0.84f, 0.075f}, {0.84f, -1.5f, 0.075f}};
        teapotTex = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        bitmapFonts = new BitmapFontRec[9];
        strokeFonts = new StrokeFontRec[9];
    }
}

