/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.io.PrintWriter;
import java.util.ListIterator;
import java.util.Vector;

public class Thread
implements Comparable {
    int nodeID = -1;
    int contextID = -1;
    int threadID = -1;
    Vector functions = null;
    Vector userevents = null;
    private double[] doubleList;
    double totalExclusiveValue = 0.0;
    double totalInclusiveValue = 0.0;
    private int maxNumberOfCalls = 0;
    private int maxNumberOfSubRoutines = 0;
    private boolean trimmed = false;
    private int numberOfMetrics = 0;
    private static int arrayIncrementSize = 7;
    private boolean debug = false;
    private PrintWriter out = null;

    public Thread() {
        this.doubleList = new double[arrayIncrementSize];
        this.numberOfMetrics = 1;
    }

    public Thread(int n) {
        this.doubleList = new double[n * arrayIncrementSize];
        this.numberOfMetrics = n;
    }

    public Thread(int n, int n2, int n3) {
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.doubleList = new double[arrayIncrementSize];
        this.numberOfMetrics = 1;
    }

    public Thread(int n, int n2, int n3, int n4) {
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.doubleList = new double[n4 * arrayIncrementSize];
        this.numberOfMetrics = n4;
    }

    public void setNodeId(int n) {
        this.nodeID = n;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public void setContextID(int n) {
        this.contextID = n;
    }

    public int getContextID() {
        return this.contextID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void initializeFunctionList(int n) {
        this.functions = new Vector(n);
        Object e = null;
        for (int i = 0; i < n; ++i) {
            this.functions.add(e);
        }
    }

    public void initializeUsereventList(int n) {
        this.userevents = new Vector(n);
        Object e = null;
        for (int i = 0; i < n; ++i) {
            this.userevents.add(e);
        }
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + arrayIncrementSize];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
        ++this.numberOfMetrics;
    }

    public int getNumberOfMetrics() {
        return this.numberOfMetrics;
    }

    public void addFunction(GlobalThreadDataElement globalThreadDataElement) {
        this.functions.addElement(globalThreadDataElement);
    }

    public void addFunction(GlobalThreadDataElement globalThreadDataElement, int n) {
        boolean bl = false;
        Object e = null;
        while (n >= this.functions.size()) {
            this.functions.add(e);
        }
        if (this.functions.elementAt(n) == null) {
            this.functions.setElementAt(globalThreadDataElement, n);
            bl = true;
        }
        if (this.debug) {
            this.outputDebugMessage("addFuntion(...)\nid:" + n + "\nname:" + globalThreadDataElement.getMappingName() + "\nadded?:" + bl + "\nfunctions.size():" + this.functions.size());
        }
    }

    public void addUserevent(GlobalThreadDataElement globalThreadDataElement) {
        this.userevents.addElement(globalThreadDataElement);
    }

    public void addUserevent(GlobalThreadDataElement globalThreadDataElement, int n) {
        boolean bl = false;
        if (n >= this.userevents.size()) {
            this.userevents.add(globalThreadDataElement);
            bl = true;
        } else if (this.userevents.elementAt(n) == null) {
            this.userevents.setElementAt(globalThreadDataElement, n);
        }
        if (this.debug) {
            this.outputDebugMessage("addUserevent(...)\nid:" + n + "\nname:" + globalThreadDataElement.getMappingName() + "\nadded?:" + bl + "\nuserevents.size():" + this.userevents.size());
        }
    }

    public GlobalThreadDataElement getFunction(int n) {
        GlobalThreadDataElement globalThreadDataElement = null;
        try {
            if (this.functions != null && n < this.functions.size()) {
                globalThreadDataElement = (GlobalThreadDataElement)this.functions.elementAt(n);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "T2");
        }
        return globalThreadDataElement;
    }

    public Vector getFunctionList() {
        return this.functions;
    }

    public ListIterator getFunctionListIterator() {
        return new DataSessionIterator(this.functions);
    }

    public GlobalThreadDataElement getUserevent(int n) {
        GlobalThreadDataElement globalThreadDataElement = null;
        try {
            if (this.userevents != null && n < this.userevents.size()) {
                globalThreadDataElement = (GlobalThreadDataElement)this.userevents.elementAt(n);
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "T3");
        }
        return globalThreadDataElement;
    }

    public Vector getUsereventList() {
        return this.userevents;
    }

    public ListIterator getUsereventListIterator() {
        return new DataSessionIterator(this.userevents);
    }

    public void setThreadData(int n) {
        if (this.debug) {
            this.outputDebugMessage("setThreadData\nmetrics:" + n);
        }
        this.setThreadDataHelper(n);
        this.setPercentData(n);
        this.setThreadDataHelper(n);
    }

    public void setThreadDataAllMetrics() {
        if (this.debug) {
            this.outputDebugMessage("setThreadDataAllMetrics()\nnumberOfMetrics:" + this.getNumberOfMetrics());
        }
        for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
            this.setThreadDataHelper(i);
            this.setPercentData(i);
            this.setThreadDataHelper(i);
        }
    }

    public void setMaxInclusiveValue(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusiveValue(int n) {
        return this.getDouble(n, 0);
    }

    public void setMaxExclusiveValue(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusiveValue(int n) {
        return this.getDouble(n, 1);
    }

    public void setMaxInclusivePercentValue(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercentValue(int n) {
        return this.getDouble(n, 2);
    }

    public void setMaxExclusivePercentValue(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercentValue(int n) {
        return this.getDouble(n, 3);
    }

    public void setMaxUserSecPerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxUserSecPerCall(int n) {
        return this.getDouble(n, 4);
    }

    public void setMaxNumberOfCalls(int n) {
        this.maxNumberOfCalls = n;
    }

    public int getMaxNumberOfCalls() {
        return this.maxNumberOfCalls;
    }

    public void setMaxNumberOfSubRoutines(int n) {
        this.maxNumberOfSubRoutines = n;
    }

    public int getMaxNumberOfSubRoutines() {
        return this.maxNumberOfSubRoutines;
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }

    public int compareTo(Object object) {
        if (object instanceof Integer) {
            return this.threadID - (Integer)object;
        }
        return this.threadID - ((Thread)object).getThreadID();
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }

    public void outputDebugMessage(String string) {
        UtilFncs.objectDebug.outputToFile(this.toString() + "\n" + string);
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getNodeID() + "," + this.getContextID() + "," + this.getThreadID();
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 5 + n2;
        try {
            this.doubleList[n3] = d;
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GT01");
        }
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 5 + n2;
        try {
            return this.doubleList[n3];
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GT01");
            return -1.0;
        }
    }

    private void setThreadDataHelper(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n2 = 0;
        int n3 = 0;
        double d6 = 0.0;
        int n4 = 0;
        ListIterator listIterator = this.getFunctionListIterator();
        while (listIterator.hasNext()) {
            GlobalThreadDataElement globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
            if (globalThreadDataElement == null) continue;
            d6 = globalThreadDataElement.getInclusiveValue(n);
            if (d6 > d) {
                d = d6;
            }
            if ((d6 = globalThreadDataElement.getExclusiveValue(n)) > d2) {
                d2 = d6;
            }
            if ((d6 = globalThreadDataElement.getInclusivePercentValue(n)) > d3) {
                d3 = d6;
            }
            if ((d6 = globalThreadDataElement.getExclusivePercentValue(n)) > d4) {
                d4 = d6;
            }
            if ((d6 = globalThreadDataElement.getUserSecPerCall(n)) > d5) {
                d5 = d6;
            }
            if ((n4 = globalThreadDataElement.getNumberOfCalls()) > n2) {
                n2 = n4;
            }
            if ((n4 = globalThreadDataElement.getNumberOfSubRoutines()) <= n3) continue;
            n3 = n4;
        }
        if (this.debug) {
            this.outputDebugMessage("setThreadDataHelper(...)\nmaxInclusiveValue:" + d + "\nmaxExclusiveValue:" + d2 + "\nmaxInclusivePercentValue:" + d3 + "\nmaxExclusivePercentValue:" + d4 + "\nmaxUserSecPerCall:" + d5 + "\nmaxNumberOfCalls:" + n2 + "\nmaxNumberOfSubroutines:" + n3);
        }
        this.setMaxInclusiveValue(n, d);
        this.setMaxExclusiveValue(n, d2);
        this.setMaxInclusivePercentValue(n, d3);
        this.setMaxExclusivePercentValue(n, d4);
        this.setMaxUserSecPerCall(n, d5);
        this.setMaxNumberOfCalls(n2);
        this.setMaxNumberOfSubRoutines(n3);
    }

    private void setPercentData(int n) {
        ListIterator listIterator = this.getFunctionListIterator();
        while (listIterator.hasNext()) {
            GlobalThreadDataElement globalThreadDataElement = (GlobalThreadDataElement)listIterator.next();
            if (globalThreadDataElement == null) continue;
            GlobalMappingElement globalMappingElement = globalThreadDataElement.getGlobalMappingElement();
            double d = this.getMaxInclusiveValue(n);
            double d2 = globalThreadDataElement.getExclusiveValue(n);
            double d3 = globalThreadDataElement.getInclusiveValue(n);
            if (d == 0.0) continue;
            double d4 = d2 / d * 100.0;
            globalThreadDataElement.setExclusivePercentValue(n, d4);
            if (globalMappingElement.getMaxExclusivePercentValue(n) < d4) {
                globalMappingElement.setMaxExclusivePercentValue(n, d4);
            }
            d4 = d3 / d * 100.0;
            globalThreadDataElement.setInclusivePercentValue(n, d4);
            if (!(globalMappingElement.getMaxInclusivePercentValue(n) < d4)) continue;
            globalMappingElement.setMaxInclusivePercentValue(n, d4);
        }
    }
}

