/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalThreadDataElement;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.ParaProfError;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.Trial;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMLSupport {
    private Trial trial = null;
    private String[] lookupBegin = new String[]{"\t\t<inclperc>", "\t\t<inclutime>", "\t\t<exclperc>", "\t\t<exclutime>", "\t\t<inclutimePcall>", "\t\t<call>", "\t\t<subrs>", "\t\t<maxvalue>", "\t\t<minvalue>", "\t\t<meanvalue>", "\t\t<stddevvalue>", "\t\t<funID>", "\t\t<ueID>", "\t\t<numofsamples>", "\t\t<fungroup>", "\t\t<uename>", "\t   <instrumentedobj>", "\t   <userevent>", "\t   <totalfunction>", "\t   <meanfunction>", "\t   <funnameidmap>", "\t   <uenameidmap>"};
    private String[] lookupEnd = new String[]{"</inclperc>", "</inclutime>", "</exclperc>", "</exclutime>", "</inclutimePcall>", "</call>", "</subrs>", "</maxvalue>", "</minvalue>", "</meanvalue>", "</stddevvalue>", "</funID>", "</ueID>", "</numofsamples>", "<fungroup>", "<uename>", "\t   </instrumentedobj>", "\t   </userevent>", "\t   </totalfunction>", "\t   </meanfunction>", "\t   </funnameidmap>", "\t   </uenameidmap>"};
    private ParaProfError xmlWriteError = new ParaProfError("", "XML Write Error: See console for details.", "An error occurred whilst writing XML file. Operation aborted!", "Note: Dependent operations also aborted.", null, false);

    public XMLSupport() {
    }

    public XMLSupport(Trial trial) {
        this.trial = trial;
    }

    public void writeXmlFiles(int n, File file) {
        Object object;
        GlobalMapping globalMapping = this.trial.getDataSession().getGlobalMapping();
        Vector vector = globalMapping.getMapping(1);
        String[] stringArray = new String[vector.size()];
        int n2 = 0;
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (GlobalMappingElement)object2.nextElement();
            stringArray[n2++] = ((GlobalMappingElement)object).getMappingName();
        }
        object2 = this.trial.getMaxNCTNumbers();
        try {
            Serializable serializable;
            object = "";
            String string = "";
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = InetAddress.getLocalHost().getHostName();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("<?xml version=\"1.0\"?>", 0, "<?xml version=\"1.0\"?>".length());
            bufferedWriter.newLine();
            bufferedWriter.write("<Trials>", 0, "<Trials>".length());
            bufferedWriter.newLine();
            bufferedWriter.write("    <Onetrial Metric='" + this.trial.getDataSession().getMetricName(n) + "'>", 0, ("    <Onetrial Metric='" + this.trial.getDataSession().getMetricName(n) + "'>").length());
            bufferedWriter.newLine();
            this.writeComputationModel(bufferedWriter, (int)(object2[0] + true), (int)(object2[1] + true), (int)(object2[2] + true));
            bufferedWriter.write("\t<Env>", 0, "\t<Env>".length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t   <AppID>" + this.trial.getApplicationID() + "</AppID>", 0, ("\t   <AppID>" + this.trial.getApplicationID() + "</AppID>").length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t   <ExpID>" + this.trial.getExperimentID() + "</ExpID>", 0, ("\t   <ExpID>" + this.trial.getExperimentID() + "</ExpID>").length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t   <TrialName>" + this.trial.getName() + "</TrialName>", 0, ("\t   <TrialName>" + this.trial.getName() + "</TrialName>").length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t</Env>", 0, "\t</Env>".length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t<FunAmt>" + globalMapping.getNumberOfMappings(0) + "</FunAmt>", 0, ("\t<FunAmt>" + globalMapping.getNumberOfMappings(0) + "</FunAmt>").length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t<UserEventAmt>" + globalMapping.getNumberOfMappings(2) + "</UserEventAmt>", 0, ("\t<UserEventAmt>" + globalMapping.getNumberOfMappings(2) + "</UserEventAmt>").length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t<Pprof>", 0, "\t<Pprof>".length());
            bufferedWriter.newLine();
            this.writeBeginObject(bufferedWriter, 20);
            Object object3 = globalMapping.getMapping(0).elements();
            while (object3.hasMoreElements()) {
                serializable = (GlobalMappingElement)object3.nextElement();
                if (serializable == null) continue;
                this.writeNameIDMap(bufferedWriter, ((GlobalMappingElement)serializable).getMappingName(), ((GlobalMappingElement)serializable).getMappingID());
            }
            this.writeEndObject(bufferedWriter, 20);
            this.writeBeginObject(bufferedWriter, 21);
            object3 = globalMapping.getMapping(2).elements();
            while (object3.hasMoreElements()) {
                serializable = (GlobalMappingElement)object3.nextElement();
                if (serializable == null) continue;
                this.writeNameIDMap(bufferedWriter, ((GlobalMappingElement)serializable).getMappingName(), ((GlobalMappingElement)serializable).getMappingID());
            }
            this.writeEndObject(bufferedWriter, 21);
            object3 = new StringBuffer(10);
            serializable = this.trial.getDataSession().getNCT().getNodes();
            Enumeration enumeration = ((Vector)serializable).elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                Vector vector2 = node.getContexts();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    Context context = (Context)enumeration2.nextElement();
                    Vector vector3 = context.getThreads();
                    Enumeration enumeration3 = vector3.elements();
                    while (enumeration3.hasMoreElements()) {
                        GlobalThreadDataElement globalThreadDataElement;
                        Thread thread = (Thread)enumeration3.nextElement();
                        Vector vector4 = thread.getFunctionList();
                        Vector vector5 = thread.getUsereventList();
                        this.writeIDs(bufferedWriter, thread.getNodeID(), thread.getContextID(), thread.getThreadID());
                        Enumeration enumeration4 = vector4.elements();
                        while (enumeration4.hasMoreElements()) {
                            globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                            if (globalThreadDataElement == null) continue;
                            this.writeBeginObject(bufferedWriter, 16);
                            this.writeInt(bufferedWriter, 11, globalThreadDataElement.getMappingID());
                            ((StringBuffer)object3).delete(0, ((StringBuffer)object3).length());
                            int[] nArray = globalThreadDataElement.getGroups();
                            for (int i = 0; i < nArray.length; ++i) {
                                if (i == 0) {
                                    ((StringBuffer)object3).append(stringArray[nArray[i]]);
                                    continue;
                                }
                                ((StringBuffer)object3).append(":" + stringArray[nArray[i]]);
                            }
                            this.writeString(bufferedWriter, 14, ((StringBuffer)object3).toString());
                            this.writeDouble(bufferedWriter, 0, globalThreadDataElement.getInclusivePercentValue(n));
                            this.writeDouble(bufferedWriter, 1, globalThreadDataElement.getInclusiveValue(n));
                            this.writeDouble(bufferedWriter, 2, globalThreadDataElement.getExclusivePercentValue(n));
                            this.writeDouble(bufferedWriter, 3, globalThreadDataElement.getExclusiveValue(n));
                            this.writeDouble(bufferedWriter, 5, globalThreadDataElement.getNumberOfCalls());
                            this.writeDouble(bufferedWriter, 6, globalThreadDataElement.getNumberOfSubRoutines());
                            this.writeDouble(bufferedWriter, 4, globalThreadDataElement.getUserSecPerCall(n));
                            this.writeEndObject(bufferedWriter, 16);
                        }
                        if (vector5 == null) continue;
                        enumeration4 = vector5.elements();
                        while (enumeration4.hasMoreElements()) {
                            globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                            if (globalThreadDataElement == null) continue;
                            this.writeBeginObject(bufferedWriter, 17);
                            this.writeInt(bufferedWriter, 12, globalThreadDataElement.getMappingID());
                            this.writeInt(bufferedWriter, 13, globalThreadDataElement.getUserEventNumberValue());
                            this.writeDouble(bufferedWriter, 7, globalThreadDataElement.getUserEventMaxValue());
                            this.writeDouble(bufferedWriter, 8, globalThreadDataElement.getUserEventMinValue());
                            this.writeDouble(bufferedWriter, 9, globalThreadDataElement.getUserEventMeanValue());
                            this.writeBeginObject(bufferedWriter, 17);
                        }
                    }
                }
            }
            bufferedWriter.write("\t</Pprof>", 0, "\t</Pprof>".length());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("    </Onetrial>", 0, "    </Onetrial>".length());
            bufferedWriter.newLine();
            bufferedWriter.write("</Trials>", 0, "</Trials>".length());
            bufferedWriter.newLine();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeComputationModel(BufferedWriter bufferedWriter, int n, int n2, int n3) {
        try {
            bufferedWriter.write("\t<ComputationModel>", 0, "\t<ComputationModel>".length());
            bufferedWriter.newLine();
            String string = "\t   <node level=\"Top\" statis_info=\"sum\">" + n + "</node>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = "\t   <context level=\"Secondary\" statis_info=\"contextPnode\">" + n2 + "</context>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = "\t   <thread level=\"Lowest\" statis_info=\"threadPcontext\">" + n3 + "</thread>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            bufferedWriter.write("\t</ComputationModel>", 0, "\t</ComputationModel>".length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeComputationModel(BufferedWriter writer, int node, int context, int thread)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeIDs(BufferedWriter bufferedWriter, int n, int n2, int n3) {
        try {
            String string = "\t   <nodeID>" + n + "</nodeID>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = "\t   <contextID>" + n2 + "</contextID>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
            string = "\t   <threadID>" + n3 + "</threadID>";
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeIDs(BufferedWriter writer, int node, int context, int thread)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeBeginObject(BufferedWriter bufferedWriter, int n) {
        try {
            bufferedWriter.write(this.lookupBegin[n], 0, this.lookupBegin[n].length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeBeginObject(BufferedWriter writer, int type)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeEndObject(BufferedWriter bufferedWriter, int n) {
        try {
            bufferedWriter.write(this.lookupEnd[n], 0, this.lookupEnd[n].length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeEndObject(BufferedWriter writer, int type)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeFunctionName(BufferedWriter bufferedWriter, String string) {
        try {
            string = this.replace(string, "&", "&amp;");
            string = this.replace(string, "<", "&lt;");
            string = this.replace(string, ">", "&gt;");
            String string2 = "\t\t<funname>" + string + "</funname>";
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeFunctionName(BufferedWriter writer, String funname)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeNameIDMap(BufferedWriter bufferedWriter, String string, int n) {
        try {
            string = this.replace(string, "&", "&amp;");
            string = this.replace(string, "<", "&lt;");
            string = this.replace(string, ">", "&gt;");
            String string2 = "\t\t<nameid>\"" + string + "\"" + n + "</nameid>";
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeFunctionName(BufferedWriter writer, String funname)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeString(BufferedWriter bufferedWriter, int n, String string) {
        try {
            String string2 = this.lookupBegin[n] + string + this.lookupEnd[n];
            bufferedWriter.write(string2, 0, string2.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeString(BufferedWriter writer, int type, String s1)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeInt(BufferedWriter bufferedWriter, int n, int n2) {
        try {
            String string = this.lookupBegin[n] + n2 + this.lookupEnd[n];
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeInt(BufferedWriter writer, int type, int i)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public void writeDouble(BufferedWriter bufferedWriter, int n, double d) {
        try {
            String string = this.lookupBegin[n] + d + this.lookupEnd[n];
            bufferedWriter.write(string, 0, string.length());
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            this.xmlWriteError.location = "writeDouble(BufferedWriter writer, int type, double d)";
            UtilFncs.systemError(this.xmlWriteError, null, null);
        }
    }

    public String getMetric(String string) {
        if (string.length() > 26) {
            return string.substring(26, string.length());
        }
        return new String("");
    }

    public String replace(String string, String string2, String string3) {
        int n;
        String string4 = "";
        while ((n = string.indexOf(string2)) != -1) {
            if (n > 0) {
                string4 = string4 + string.substring(0, n);
            }
            string4 = string4 + string3;
            string = string.substring(n + 1);
        }
        string4 = string4 + string;
        return string4;
    }

    public String getFunAmt(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            String string2 = stringTokenizer.nextToken();
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

