/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.loader;

import edu.uoregon.tau.dms.database.DB;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LoadHandler
extends DefaultHandler {
    protected String appid = "";
    protected String expid = "";
    protected String probsize = "";
    protected String trialName = "";
    protected String userData = "";
    protected String problemString = "";
    protected String currentElement = "";
    protected String documentName = "";
    protected String documentId = "";
    protected String metricStr = "";
    protected String metricId = "";
    protected String trialId = "";
    protected String trialTime = "";
    protected boolean newTrial = false;
    protected int funAmt;
    protected int ueAmt;
    protected String nodenum = "";
    protected String contextpnode = "";
    protected String threadpcontext = "";
    protected String nodeid = "";
    protected String threadid = "";
    protected String contextid = "";
    protected String funid = "";
    protected String funname = "";
    protected String fungroup = "";
    protected String funIndex = "";
    protected String locid = "";
    protected String inclperc = "";
    protected String incl = "";
    protected String exclperc = "";
    protected String excl = "";
    protected String callnum = "";
    protected String subrs = "";
    protected String inclpcall = "";
    protected String uename = "";
    protected String ueid = "";
    protected String uegroup = "UE";
    protected String numofsamples = "";
    protected String maxvalue = "";
    protected String minvalue = "";
    protected String meanvalue = "";
    protected String standardDeviation = "";
    private DB dbconnector;
    private String[] funArray;
    private String[] ueArray;

    public LoadHandler(DB dB, String string, String string2) {
        this.dbconnector = dB;
        this.trialId = string;
        this.problemString = string2;
    }

    public DB getDB() {
        return this.dbconnector;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getTrialId() {
        return this.trialId;
    }

    public String getDocumentName() {
        if (this.documentName == null) {
            this.setDocumentName("NoName" + this.getDocumentId());
        }
        return this.documentName;
    }

    public void setDocumentName(String string) {
        this.documentName = string;
    }

    public void startDocument() throws SAXException {
    }

    public String metricAttrToString(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(attributes.getValue(i));
        }
        return stringBuffer.toString();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("Onetrial")) {
            this.metricStr = this.metricAttrToString(attributes);
        }
        this.currentElement = new String(string2);
    }

    public void characters(char[] cArray, int n, int n2) {
        boolean bl = true;
        for (int i = n; i < n + n2; ++i) {
            if (Character.isWhitespace(cArray[i])) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        String string = new String(cArray, n, n2);
        if (this.currentElement.equals("AppID")) {
            this.appid = string;
            if (this.appid.length() == 0) {
                System.out.println("No valid application ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ExpID")) {
            this.expid = string;
            if (this.expid.length() == 0) {
                System.out.println("No valid experiment ID. Quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("ProblemSize")) {
            this.probsize = string;
        } else if (this.currentElement.equals("TrialName")) {
            this.trialName = string;
        } else if (this.currentElement.equals("UserData")) {
            this.userData = string;
        } else if (this.currentElement.equals("Trialtime")) {
            this.trialTime = string;
        } else if (this.currentElement.equals("FunAmt")) {
            this.funAmt = Integer.parseInt(string);
            if (this.funAmt > 0) {
                this.funArray = new String[this.funAmt];
            }
        } else if (this.currentElement.equals("UserEventAmt")) {
            this.ueAmt = Integer.parseInt(string);
            if (this.ueAmt > 0) {
                this.ueArray = new String[this.ueAmt];
            }
            if (this.ueAmt + this.funAmt == 0) {
                System.out.println("Cannot get a valid function amount, quit loadding.");
                System.exit(-1);
            }
        } else if (this.currentElement.equals("node")) {
            this.nodenum = string;
        } else if (this.currentElement.equals("context")) {
            this.contextpnode = string;
        } else if (this.currentElement.equals("thread")) {
            this.threadpcontext = string;
        } else if (this.currentElement.equals("nodeID")) {
            this.nodeid = string;
        } else if (this.currentElement.equals("contextID")) {
            this.contextid = string;
        } else if (this.currentElement.equals("threadID")) {
            this.threadid = string;
        } else if (this.currentElement.equals("funname")) {
            this.funname = this.funname + string;
        } else if (this.currentElement.equals("fungroup")) {
            this.fungroup = this.fungroup + string;
        } else if (this.currentElement.equals("funID")) {
            this.funid = string;
        } else if (this.currentElement.equals("inclperc")) {
            this.inclperc = string;
        } else if (this.currentElement.equals("inclutime")) {
            this.incl = string;
        } else if (this.currentElement.equals("exclperc")) {
            this.exclperc = string;
        } else if (this.currentElement.equals("exclutime")) {
            this.excl = string;
        } else if (this.currentElement.equals("call")) {
            this.callnum = string;
        } else if (this.currentElement.equals("subrs")) {
            this.subrs = string;
        } else if (this.currentElement.equals("inclutimePcall")) {
            this.inclpcall = string;
        } else if (this.currentElement.equals("uename")) {
            this.uename = string;
        } else if (this.currentElement.equals("ueID")) {
            this.ueid = string;
        } else if (this.currentElement.equals("numofsamples")) {
            this.numofsamples = string;
        } else if (this.currentElement.equals("maxvalue")) {
            this.maxvalue = string;
        } else if (this.currentElement.equals("minvalue")) {
            this.minvalue = string;
        } else if (this.currentElement.equals("meanvalue")) {
            this.meanvalue = string;
        } else if (this.currentElement.equals("stddevvalue")) {
            this.standardDeviation = string;
        }
    }

    public void endElement(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.equalsIgnoreCase("usereventamt")) {
            if (this.trialId.compareTo("0") == 0) {
                this.newTrial = true;
                stringBuffer.append("insert into trial (experiment, name, time, node_count, contexts_per_node, threads_per_context, userdata, problem_definition)");
                stringBuffer.append(" values ");
                stringBuffer.append("(" + this.expid + ", '" + this.trialName + "', '" + this.trialTime + "', " + this.nodenum + ", " + this.contextpnode + ", " + this.threadpcontext + ", '" + this.userData + "', '" + this.problemString + "'); ");
                try {
                    this.getDB().executeUpdate(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        stringBuffer.append("select LAST_INSERT_ID();");
                    } else {
                        stringBuffer.append("select currval('trial_id_seq');");
                    }
                    this.trialId = this.getDB().getDataItem(stringBuffer.toString());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    System.out.println(stringBuffer.toString());
                    System.exit(0);
                }
            } else {
                try {
                    this.newTrial = false;
                    stringBuffer.append("select id, function_number from function where trial = " + this.trialId + " order by function_number asc;");
                    ResultSet resultSet = this.getDB().executeQuery(stringBuffer.toString());
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(1);
                        int n = resultSet.getInt(2);
                        this.funArray[n] = string4;
                    }
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    System.out.println(stringBuffer.toString());
                    System.exit(0);
                }
            }
            try {
                stringBuffer.delete(0, stringBuffer.toString().length());
                stringBuffer.append("insert into metric (name, trial) values (TRIM('");
                stringBuffer.append(this.metricStr);
                stringBuffer.append("'), " + this.trialId + ");");
                this.getDB().executeUpdate(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.toString().length());
                if (this.getDB().getDBType().compareTo("mysql") == 0) {
                    stringBuffer.append("select LAST_INSERT_ID();");
                } else {
                    stringBuffer.append("select currval('metric_id_seq');");
                }
                this.metricId = this.getDB().getDataItem(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.out.println(stringBuffer.toString());
                System.exit(0);
            }
        }
        if (string2.equalsIgnoreCase("instrumentedobj")) {
            int n = Integer.parseInt(this.funid);
            if (this.funArray[n] == null) {
                if (this.fungroup.trim().length() == 0) {
                    this.fungroup = "NA";
                }
                stringBuffer.delete(0, stringBuffer.toString().length());
                stringBuffer.append("insert into function (trial, function_number, name, group_name) values (");
                stringBuffer.append(this.getTrialId() + ", ");
                stringBuffer.append(this.funid + ", '");
                stringBuffer.append(this.funname + "', '");
                stringBuffer.append(this.fungroup + "');");
                try {
                    this.getDB().executeUpdate(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        stringBuffer.append("select LAST_INSERT_ID();");
                    } else {
                        stringBuffer.append("select currval('function_id_seq');");
                    }
                    this.funArray[n] = this.getDB().getDataItem(stringBuffer.toString());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    System.out.println(stringBuffer.toString());
                    System.exit(0);
                }
            }
            stringBuffer.delete(0, stringBuffer.toString().length());
            stringBuffer.append("insert into interval_location_profile (function, node, context, thread, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            stringBuffer.append(this.funArray[n] + ", ");
            stringBuffer.append(this.nodeid + ", ");
            stringBuffer.append(this.contextid + ", ");
            stringBuffer.append(this.threadid + ", ");
            stringBuffer.append(this.metricId + ", ");
            stringBuffer.append(this.inclperc + ", ");
            stringBuffer.append(this.incl + ", ");
            stringBuffer.append(this.exclperc + ", ");
            stringBuffer.append(this.excl + ", ");
            stringBuffer.append(this.callnum + ", ");
            stringBuffer.append(this.subrs + ", ");
            stringBuffer.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.out.println(stringBuffer.toString());
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (string2.equalsIgnoreCase("userevent") && this.newTrial) {
            int n = Integer.parseInt(this.ueid);
            if (this.ueArray[n] == null) {
                stringBuffer.delete(0, stringBuffer.toString().length());
                stringBuffer.append("insert into user_event (trial, name, group_name) VALUES (");
                stringBuffer.append(this.getTrialId() + ", '");
                stringBuffer.append(this.uename + "', '");
                stringBuffer.append(this.uegroup + "');");
                try {
                    this.getDB().executeUpdate(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.toString().length());
                    if (this.getDB().getDBType().compareTo("mysql") == 0) {
                        stringBuffer.append("select LAST_INSERT_ID();");
                    } else {
                        stringBuffer.append("select currval('user_event_id_seq');");
                    }
                    this.ueArray[n] = this.getDB().getDataItem(stringBuffer.toString());
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    System.out.println(stringBuffer.toString());
                    System.exit(0);
                }
            }
            stringBuffer.delete(0, stringBuffer.toString().length());
            stringBuffer.append("insert into atomic_location_profile (user_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (");
            stringBuffer.append(this.ueArray[n] + ", ");
            stringBuffer.append(this.nodeid + ", ");
            stringBuffer.append(this.contextid + ", ");
            stringBuffer.append(this.threadid + ", ");
            stringBuffer.append(this.numofsamples + ", ");
            stringBuffer.append(this.maxvalue + ", ");
            stringBuffer.append(this.minvalue + ", ");
            stringBuffer.append(this.meanvalue + ", ");
            stringBuffer.append(this.standardDeviation + ");");
            try {
                this.getDB().executeUpdate(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.out.println(stringBuffer.toString());
                System.exit(0);
            }
            this.uename = "";
        }
        if (string2.equalsIgnoreCase("totalfunction")) {
            stringBuffer.delete(0, stringBuffer.toString().length());
            stringBuffer.append("insert into interval_total_summary (function, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            stringBuffer.append(this.funArray[Integer.parseInt(this.funid)] + ", ");
            stringBuffer.append(this.metricId + ", ");
            stringBuffer.append(this.inclperc + ", ");
            stringBuffer.append(this.incl + ", ");
            stringBuffer.append(this.exclperc + ", ");
            stringBuffer.append(this.excl + ", ");
            stringBuffer.append(this.callnum + ", ");
            stringBuffer.append(this.subrs + ", ");
            stringBuffer.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                System.out.println(stringBuffer.toString());
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
        if (string2.equalsIgnoreCase("meanfunction")) {
            stringBuffer.delete(0, stringBuffer.toString().length());
            stringBuffer.append("insert into interval_mean_summary (function, metric, inclusive_percentage, inclusive, exclusive_percentage, exclusive, call, subroutines, inclusive_per_call) VALUES ( ");
            stringBuffer.append(this.funArray[Integer.parseInt(this.funid)] + ", ");
            stringBuffer.append(this.metricId + ", ");
            stringBuffer.append(this.inclperc + ", ");
            stringBuffer.append(this.incl + ", ");
            stringBuffer.append(this.exclperc + ", ");
            stringBuffer.append(this.excl + ", ");
            stringBuffer.append(this.callnum + ", ");
            stringBuffer.append(this.subrs + ", ");
            stringBuffer.append(this.inclpcall + ");");
            try {
                this.getDB().executeUpdate(stringBuffer.toString());
            }
            catch (SQLException sQLException) {
                System.out.println(stringBuffer.toString());
                sQLException.printStackTrace();
                System.out.println(stringBuffer.toString());
                System.exit(0);
            }
            this.funname = "";
            this.fungroup = "";
        }
    }
}

