/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class RecurringDurationDatatypeValidator
extends AbstractDatatypeValidator {
    private static final boolean fDbug = false;
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    String fPattern = null;
    long fMaxInclusive = Long.MAX_VALUE;
    long fMaxExclusive = 0x7FFFFFFFFFFFFFFEL;
    long fMinInclusive = 1L;
    long fMinExclusive = 0L;
    long fDuration = 0L;
    long fPeriod = 0L;
    long[] fEnumrecurringduration = null;
    boolean isMaxExclusiveDefined = false;
    boolean isMaxInclusiveDefined = false;
    boolean isMinExclusiveDefined = false;
    boolean isMinInclusiveDefined = false;
    boolean isBaseTypeTimePeriod = false;
    int fFacetsDefined = 0;
    Hashtable fFacets = null;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();

    public RecurringDurationDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public RecurringDurationDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        if (datatypeValidator != null) {
            this.setBasetype(datatypeValidator);
            this.fFacets = hashtable;
        }
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                object = (String)enumeration.nextElement();
                if (((String)object).equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(object);
                    continue;
                }
                if (((String)object).equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    continue;
                }
                if (((String)object).equals("maxInclusive")) {
                    this.fFacetsDefined += 32;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxInclusive = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("maxExclusive")) {
                    this.fFacetsDefined += 64;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMaxExclusive = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minInclusive")) {
                    this.fFacetsDefined += 128;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinInclusive = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("minExclusive")) {
                    this.fFacetsDefined += 128;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fMinExclusive = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("period")) {
                    this.fFacetsDefined += 8192;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fPeriod = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                if (((String)object).equals("duration")) {
                    this.fFacetsDefined += 4096;
                    string = null;
                    try {
                        string = (String)hashtable.get(object);
                        this.fDuration = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        continue;
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{string, object}));
                    }
                }
                throw new InvalidDatatypeFacetException(this.getErrorString(1, 0, null));
            }
            this.isMaxExclusiveDefined = (this.fFacetsDefined & 0x40) != 0;
            this.isMaxInclusiveDefined = (this.fFacetsDefined & 0x20) != 0;
            this.isMinExclusiveDefined = (this.fFacetsDefined & 0x100) != 0;
            boolean bl2 = this.isMinInclusiveDefined = (this.fFacetsDefined & 0x80) != 0;
            if (this.isMaxExclusiveDefined && this.isMaxInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both maxInclusive and maxExclusive to be specified for the same datatype.");
            }
            if (this.isMinExclusiveDefined && this.isMinInclusiveDefined) {
                throw new InvalidDatatypeFacetException("It is an error for both minInclusive and minExclusive to be specified for the same datatype.");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (object = (Vector)hashtable.get("enumeration")) != null) {
                this.fEnumrecurringduration = new long[((Vector)object).size()];
                int n = 0;
                String string = null;
                try {
                    while (n < ((Vector)object).size()) {
                        string = (String)((Vector)object).elementAt(n);
                        this.fEnumrecurringduration[n] = RecurringDurationDatatypeValidator.normalizeRecurringDuration(string.toCharArray(), 0);
                        this.boundsCheck(this.fEnumrecurringduration[n]);
                        ++n;
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(8, 0, new Object[]{((Vector)object).elementAt(n)}));
                }
            }
            if (this.fBaseValidator != null) {
                object = null;
                try {
                    Hashtable hashtable2 = this.fBaseValidator.getFacets();
                    if (hashtable2 != null && (object = (String)hashtable2.get("period")) != null) {
                        this.fPeriod = RecurringDurationDatatypeValidator.normalizeRecurringDuration(((String)object).toCharArray(), 0);
                        if (this.fPeriod == 0L) {
                            this.isBaseTypeTimePeriod = true;
                        }
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeFacetException(this.getErrorString(5, 0, new Object[]{object, "period"}));
                }
            }
        }
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        RegularExpression regularExpression;
        if (this.fPattern != null && !(regularExpression = new RegularExpression(this.fPattern, "X")).matches(string)) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        return null;
    }

    public void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public void setLocale(Locale locale) {
    }

    public int compare(String string, String string2) {
        return -1;
    }

    public Hashtable getFacets() {
        return this.fFacets;
    }

    private static long normalizeRecurringDuration(char[] cArray, int n) throws InvalidDatatypeValueException {
        long l = 0L;
        return l;
    }

    public static Calendar normalizeInstant(char[] cArray, int n, int n2) throws InvalidDatatypeValueException {
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        boolean bl4 = false;
        char[] cArray2 = new char[]{'0', '0', '0'};
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n9 = n + n2 - 1;
        try {
            if (n2 < 16) {
                throw new ParseException("Value is too short.", 0);
            }
            gregorianCalendar.clear();
            gregorianCalendar.setLenient(false);
            if (cArray[n6] == '-' || cArray[n6] == '+') {
                gregorianCalendar.set(0, cArray[n6] == '-' ? 0 : 1);
                ++n6;
            }
            if ((n7 = RecurringDurationDatatypeValidator.indexOf(cArray, n6, '-', n6 + 5)) == -1 || n7 > n9) {
                throw new ParseException("Year separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(1, RecurringDurationDatatypeValidator.parseInt(cArray, n6, n7 - n6));
            n6 = n7 + 1;
            gregorianCalendar.set(2, RecurringDurationDatatypeValidator.parseInt(cArray, n6, 2) - 1);
            if (cArray[n6 += 2] != '-') {
                throw new ParseException("Month separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(5, RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != 'T') {
                throw new ParseException("Time separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(11, RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (cArray[n6 += 3] != ':') {
                throw new ParseException("Hour separator is missing or misplaced.", n6);
            }
            gregorianCalendar.set(12, RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
            if (n9 - (n6 += 3) > 1 && cArray[n6] == ':') {
                gregorianCalendar.set(13, RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2));
                if ((n6 += 3) < n9 && cArray[n6] == '.') {
                    ++n6;
                    n8 = 0;
                    while (n6 <= n9 && n8 < 3 && Character.isDigit(cArray[n6])) {
                        cArray2[n8++] = cArray[n6++];
                    }
                    gregorianCalendar.set(14, RecurringDurationDatatypeValidator.parseInt(cArray2, 0, 3));
                }
                while (n6 <= n9 && Character.isDigit(cArray[n6])) {
                    ++n6;
                }
            }
            if (n6 <= n9) {
                if (cArray[n6] == 'Z') {
                    gregorianCalendar.set(15, 0);
                } else if (cArray[n6] == '-' || cArray[n6] == '+') {
                    bl2 = cArray[n6] == '-';
                    n4 = RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 1, 2);
                    if (n9 - n6 == 5) {
                        if (cArray[n6 + 3] != ':') {
                            throw new ParseException("time zone must be 'hh:mm'.", n6);
                        }
                        n5 = RecurringDurationDatatypeValidator.parseInt(cArray, n6 + 4, 2);
                    }
                    n3 = n4 * 3600000 + n5 * 60000;
                    gregorianCalendar.set(15, bl2 ? -n3 : n3);
                } else {
                    throw new ParseException("Unrecognized time zone.", n6);
                }
            }
            return gregorianCalendar;
        }
        catch (Exception exception) {
            throw new InvalidDatatypeValueException("Unable to parse timeInstant " + exception.toString());
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    private void boundsCheck(long l) throws InvalidDatatypeFacetException {
        boolean bl = false;
        boolean bl2 = false;
        if (this.isMaxInclusiveDefined) {
            bl = l <= this.fMaxInclusive;
        } else if (this.isMaxExclusiveDefined) {
            boolean bl3 = bl = l < this.fMaxExclusive;
        }
        if (this.isMinInclusiveDefined) {
            bl2 = l >= this.fMinInclusive;
        } else if (this.isMinExclusiveDefined) {
            boolean bl4 = bl2 = l > this.fMinExclusive;
        }
        if (!bl || !bl2) {
            throw new InvalidDatatypeFacetException(this.getErrorString(9, 0, new Object[]{new Long(l), "", "", "", ""}));
        }
    }

    private void enumCheck(long l) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < this.fEnumrecurringduration.length) {
            if (l == this.fEnumrecurringduration[n]) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(10, 0, new Object[]{new Long(l)}));
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    private static final int indexOf(char[] cArray, int n, char c) {
        return RecurringDurationDatatypeValidator.indexOf(cArray, n, c, cArray.length - 1);
    }

    private static final int indexOf(char[] cArray, int n, char c, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (cArray[n3] == c) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static final int indexOneOf(char[] cArray, int n, String string) {
        return RecurringDurationDatatypeValidator.indexOneOf(cArray, n, string, cArray.length - 1);
    }

    private static final int indexOneOf(char[] cArray, int n, String string, int n2) {
        int n3 = n;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < string.length()) {
                if (cArray[n3] == string.charAt(n4)) {
                    return n3;
                }
                ++n4;
            }
            ++n3;
        }
        return -1;
    }

    private static final int parseInt(char[] cArray, int n, int n2) throws NumberFormatException {
        int n3;
        if (cArray == null) {
            throw new NumberFormatException("null");
        }
        int n4 = 10;
        int n5 = 0;
        boolean bl = false;
        int n6 = n;
        int n7 = 0;
        if (n2 <= 0) {
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        if (cArray[n6] == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n6;
        } else if (cArray[n6] == '+') {
            bl = false;
            n3 = -2147483647;
            ++n6;
        } else {
            n3 = -2147483647;
        }
        int n8 = n3 / n4;
        if (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 = -n7;
        }
        while (n6 < n + n2) {
            if ((n7 = Character.digit(cArray[n6++], n4)) < 0) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if (n5 < n8) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            if ((n5 *= n4) < n3 + n7) {
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            n5 -= n7;
        }
        if (bl) {
            if (n6 > 1) {
                return n5;
            }
            throw new NumberFormatException(new String(cArray, n, n2));
        }
        return -n5;
    }
}

