/*
 * Decompiled with CFR 0.152.
 */
package jRacy;

import jRacy.GlobalMapping;
import jRacy.GlobalMappingElement;
import jRacy.MappingDataWindowPanel;
import jRacy.StaticMainWindowData;
import jRacy.Trial;
import jRacy.jRacy;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class MappingDataWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private int mappingID = -1;
    private String mappingName = null;
    private JMenu unitsMenu;
    JMenu valuePercentMenu;
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    private ButtonGroup inclusiveExclusiveGroup = null;
    private ButtonGroup valuePercentGroup = null;
    private ButtonGroup unitsGroup = null;
    private ButtonGroup metricGroup = null;
    private JRadioButtonMenuItem metricButton = new JRadioButtonMenuItem("Selected Metric", true);
    private JRadioButtonMenuItem inclusiveRadioButton = new JRadioButtonMenuItem("Inclusive", false);
    private JRadioButtonMenuItem exclusiveRadioButton = new JRadioButtonMenuItem("Exclusive", true);
    private JRadioButtonMenuItem numOfCallsRadioButton = new JRadioButtonMenuItem("Number of Calls", false);
    private JRadioButtonMenuItem numOfSubRoutinesRadioButton = new JRadioButtonMenuItem("Number of Subroutines", false);
    private JRadioButtonMenuItem userSecPerCallRadioButton = new JRadioButtonMenuItem("Per Call Value", false);
    private JRadioButtonMenuItem valueButton = null;
    private JRadioButtonMenuItem percentButton = null;
    private JRadioButtonMenuItem secondsButton = null;
    private JRadioButtonMenuItem millisecondsButton = null;
    private JRadioButtonMenuItem microsecondsButton = null;
    private JRadioButtonMenuItem displaySlidersButton;
    private JLabel sliderMultipleLabel = new JLabel("Slider Mulitiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane mappingDataWinPanelScrollPane;
    private Trial trial = null;
    StaticMainWindowData sMWData = null;
    Vector sMWGeneralData = null;
    MappingDataWindowPanel mappingDataWinPanelRef = null;
    private String metric = "Exclusive";
    boolean inclusive = false;
    boolean percent = true;
    private String unitsString = null;

    public MappingDataWindow() {
        try {
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.setTitle("Wrong constructor used");
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW01");
        }
    }

    public MappingDataWindow(Trial trial, int n, StaticMainWindowData staticMainWindowData) {
        try {
            this.mappingID = n;
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            ((Component)this).setLocation(new Point(300, 200));
            ((Component)this).setSize(new Dimension(550, 550));
            this.inclusive = false;
            this.percent = true;
            this.unitsString = "milliseconds";
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
            this.mappingName = globalMappingElement.getMappingName();
            this.setTitle("Function Data Window: " + this.trial.getProfilePathName());
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    MappingDataWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (jRacy.helpWindow.isVisible()) {
                jRacy.helpWindow.clearText();
                jRacy.helpWindow.writeText("This is the function data window for:");
                jRacy.helpWindow.writeText(this.mappingName);
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("This window shows you this function's statistics across all the threads.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                jRacy.helpWindow.writeText("");
                jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                jRacy.helpWindow.writeText("for this function.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            jMenu2.addMenuListener(this);
            JMenu jMenu3 = new JMenu("Select Metric");
            this.metricGroup = new ButtonGroup();
            this.inclusiveRadioButton.addActionListener(this);
            this.exclusiveRadioButton.addActionListener(this);
            this.numOfCallsRadioButton.addActionListener(this);
            this.numOfSubRoutinesRadioButton.addActionListener(this);
            this.userSecPerCallRadioButton.addActionListener(this);
            this.metricGroup.add(this.inclusiveRadioButton);
            this.metricGroup.add(this.exclusiveRadioButton);
            this.metricGroup.add(this.numOfCallsRadioButton);
            this.metricGroup.add(this.numOfSubRoutinesRadioButton);
            this.metricGroup.add(this.userSecPerCallRadioButton);
            jMenu3.add(this.inclusiveRadioButton);
            jMenu3.add(this.exclusiveRadioButton);
            jMenu3.add(this.numOfCallsRadioButton);
            jMenu3.add(this.numOfSubRoutinesRadioButton);
            jMenu3.add(this.userSecPerCallRadioButton);
            jMenu2.add(jMenu3);
            this.valuePercentMenu = new JMenu("Select Value or Percent");
            this.valuePercentGroup = new ButtonGroup();
            this.percentButton = new JRadioButtonMenuItem("Percent", true);
            this.percentButton.addActionListener(this);
            this.valueButton = new JRadioButtonMenuItem("Value", false);
            this.valueButton.addActionListener(this);
            this.valuePercentGroup.add(this.percentButton);
            this.valuePercentGroup.add(this.valueButton);
            this.valuePercentMenu.add(this.percentButton);
            this.valuePercentMenu.add(this.valueButton);
            jMenu2.add(this.valuePercentMenu);
            this.unitsMenu = new JMenu("Select Units");
            this.unitsGroup = new ButtonGroup();
            this.secondsButton = new JRadioButtonMenuItem("Seconds", false);
            this.secondsButton.addActionListener(this);
            this.millisecondsButton = new JRadioButtonMenuItem("Milliseconds", false);
            this.millisecondsButton.addActionListener(this);
            this.microsecondsButton = new JRadioButtonMenuItem("Microseconds", true);
            this.microsecondsButton.addActionListener(this);
            this.unitsGroup.add(this.secondsButton);
            this.unitsGroup.add(this.millisecondsButton);
            this.unitsGroup.add(this.microsecondsButton);
            this.unitsMenu.add(this.secondsButton);
            this.unitsMenu.add(this.millisecondsButton);
            this.unitsMenu.add(this.microsecondsButton);
            jMenu2.add(this.unitsMenu);
            this.displaySlidersButton = new JRadioButtonMenuItem("Display Sliders", false);
            this.displaySlidersButton.addActionListener(this);
            jMenu2.add(this.displaySlidersButton);
            JMenu jMenu4 = new JMenu("Windows");
            jMenu4.addMenuListener(this);
            JMenuItem jMenuItem3 = new JMenuItem("Show Function Ledger");
            jMenuItem3.addActionListener(this);
            jMenu4.add(jMenuItem3);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu4.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu4.add(this.userEventLedgerItem);
            JMenuItem jMenuItem4 = new JMenuItem("Close All Sub-Windows");
            jMenuItem4.addActionListener(this);
            jMenu4.add(jMenuItem4);
            JMenu jMenu5 = new JMenu("Help");
            JMenuItem jMenuItem5 = new JMenuItem("About Racy");
            jMenuItem5.addActionListener(this);
            jMenu5.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Show Help Window");
            jMenuItem6.addActionListener(this);
            jMenu5.add(jMenuItem6);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.mappingDataWinPanelRef = new MappingDataWindowPanel(this.trial, n, this);
            this.mappingDataWinPanelScrollPane = new JScrollPane(this.mappingDataWinPanelRef);
            this.mappingDataWinPanelScrollPane.setBorder(border);
            this.mappingDataWinPanelScrollPane.setPreferredSize(new Dimension(500, 450));
            String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
            this.sliderMultiple = new JComboBox<String>(stringArray);
            this.sliderMultiple.addActionListener(this);
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.mappingDataWinPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                } else if (string.equals("Exit Racy!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    System.exit(0);
                } else if (string.equals("Inclusive")) {
                    if (this.inclusiveRadioButton.isSelected()) {
                        this.metric = "Inclusive";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Exclusive")) {
                    if (this.exclusiveRadioButton.isSelected()) {
                        this.metric = "Exclusive";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Number of Calls")) {
                    if (this.numOfCallsRadioButton.isSelected()) {
                        this.metric = "Number of Calls";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Number of Subroutines")) {
                    if (this.numOfSubRoutinesRadioButton.isSelected()) {
                        this.metric = "Number of Subroutines";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Per Call Value")) {
                    if (this.userSecPerCallRadioButton.isSelected()) {
                        this.metric = "Per Call Value";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Percent")) {
                    if (this.percentButton.isSelected()) {
                        this.percent = true;
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Value")) {
                    if (this.valueButton.isSelected()) {
                        this.percent = false;
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Seconds")) {
                    if (this.secondsButton.isSelected()) {
                        this.unitsString = "Seconds";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Microseconds")) {
                    if (this.microsecondsButton.isSelected()) {
                        this.unitsString = "Microseconds";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Milliseconds")) {
                    if (this.millisecondsButton.isSelected()) {
                        this.unitsString = "Milliseconds";
                        this.mappingDataWinPanelRef.repaint();
                    }
                } else if (string.equals("Display Sliders")) {
                    if (this.displaySlidersButton.isSelected()) {
                        this.displaySiders(true);
                    } else {
                        this.displaySiders(false);
                    }
                } else if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, jRacy.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    jRacy.helpWindow.clearText();
                    jRacy.helpWindow.show();
                    jRacy.helpWindow.writeText("This is the mapping data window for:");
                    jRacy.helpWindow.writeText(this.mappingName);
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("This window shows you this mapping's statistics across all the threads.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    jRacy.helpWindow.writeText("");
                    jRacy.helpWindow.writeText("Right click anywhere within this window to bring up a popup");
                    jRacy.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    jRacy.helpWindow.writeText("for this mapping.");
                }
            } else if (object == this.sliderMultiple) {
                this.mappingDataWinPanelRef.changeInMultiples();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW03");
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.mappingDataWinPanelRef.changeInMultiples();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            String string = this.trial.getCounterName();
            string = string.toUpperCase();
            boolean bl = false;
            boolean bl2 = false;
            if (string.equals("DEFAULT")) {
                bl = true;
            } else if (string.indexOf("TIME") != -1) {
                bl2 = true;
            }
            if (this.trial.groupNamesPresent()) {
                this.mappingGroupLedgerItem.setEnabled(true);
            } else {
                this.mappingGroupLedgerItem.setEnabled(false);
            }
            if (this.trial.userEventsPresent()) {
                this.userEventLedgerItem.setEnabled(true);
            } else {
                this.userEventLedgerItem.setEnabled(false);
            }
            if (this.metric.equals("Number of Calls") || this.metric.equals("Number of Subroutines") || this.metric.equals("Per Call Value")) {
                this.valuePercentMenu.setEnabled(false);
                this.unitsMenu.setEnabled(false);
            } else if (this.percent) {
                this.valuePercentMenu.setEnabled(true);
                this.unitsMenu.setEnabled(false);
            } else {
                this.valuePercentMenu.setEnabled(true);
                this.unitsMenu.setEnabled(true);
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "TDW04");
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.mappingDataWinPanelRef.repaint();
            } else if (string.equals("colorEvent")) {
                this.mappingDataWinPanelRef.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.sMWGeneralData = null;
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        try {
            if (this.sMWGeneralData == null) {
                this.sMWGeneralData = this.sMWData.getSMWMappingData(this.mappingID);
                return this.sMWGeneralData;
            }
            return this.sMWGeneralData;
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW06");
            return null;
        }
    }

    public String getMetric() {
        return this.metric;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public boolean isPercent() {
        return this.percent;
    }

    public String units() {
        return this.unitsString;
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW07");
        }
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        try {
            string = (String)this.sliderMultiple.getSelectedItem();
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW08");
            return 0.0;
        }
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.mappingDataWinPanelScrollPane);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.mappingDataWinPanelScrollPane, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.mappingDataWinPanelScrollPane);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 0.95;
            this.gbc.weighty = 0.98;
            this.addCompItem(this.mappingDataWinPanelScrollPane, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW09");
        }
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (jRacy.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A mapping window for: \"" + this.mappingName + "\" is closing");
                System.out.println("Clearing resourses for that window.");
            }
            ((Component)this).setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            jRacy.systemError(exception, null, "MDW10");
        }
    }
}

