/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import perfdb.loadxml.AppLoadHandler;
import perfdb.loadxml.ExpLoadHandler;
import perfdb.loadxml.LoadHandler;
import perfdb.loadxml.LoadHandler2;
import perfdb.util.dbinterface.DB;

public class Load {
    private DB db = null;
    private String parserClass;

    public Load(String parserClassIn) {
        this.parserClass = new String(parserClassIn);
    }

    public Load(DB db, String parserClassIn) {
        this.parserClass = new String(parserClassIn);
        this.setDB(db);
    }

    public DB getDB() {
        return this.db;
    }

    public void setDB(DB newValue) {
        this.db = newValue;
    }

    public LoadHandler newHandler(String trialId, String problemFile) {
        return new LoadHandler(this.getDB(), trialId, problemFile);
    }

    public LoadHandler2 newHandler2(String trialId, String problemFile) {
        return new LoadHandler2(this.getDB(), trialId, problemFile);
    }

    public AppLoadHandler newAppHandler() {
        return new AppLoadHandler(this.getDB());
    }

    public ExpLoadHandler newExpHandler(String application) {
        return new ExpLoadHandler(this.getDB(), application);
    }

    /*
     * Exception decompiling
     */
    public String parse(String xmlFile, String trialid, String problemFile, boolean bulkLoad) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String parseApp(String appFile) {
        try {
            XMLReader xmlreader = XMLReaderFactory.createXMLReader(this.parserClass);
            AppLoadHandler handler = this.newAppHandler();
            xmlreader.setContentHandler(handler);
            xmlreader.setErrorHandler(handler);
            try {
                File file = new File(appFile);
                xmlreader.parse(new InputSource(new FileInputStream(file)));
                return handler.getAppId();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String parseExp(String expFile, String application) {
        try {
            XMLReader xmlreader = XMLReaderFactory.createXMLReader(this.parserClass);
            ExpLoadHandler handler = this.newExpHandler(application);
            xmlreader.setContentHandler(handler);
            xmlreader.setErrorHandler(handler);
            try {
                File file = new File(expFile);
                xmlreader.parse(new InputSource(new FileInputStream(file)));
                return handler.getExpId();
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String lookupApp(String name, String version) {
        StringBuffer buf = new StringBuffer();
        buf.append("select distinct id from ");
        buf.append("application ");
        if (version.trim().length() == 0) {
            buf.append("  where name='" + name.trim() + "'; ");
        } else {
            buf.append("  where name='" + name.trim() + "' and version='" + version.trim() + "'; ");
        }
        try {
            ResultSet appId = this.getDB().executeQuery(buf.toString());
            if (!appId.next()) {
                System.out.println("no such application found");
                appId.close();
                return null;
            }
            String str = appId.getString(1);
            appId.close();
            return str;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String lookupExp(String exptable, String appid, String sysinfo, String configinfo, String compilerinfo, String instruinfo) {
        StringBuffer buf = new StringBuffer();
        buf.append("select distinct id from ");
        buf.append(exptable);
        buf.append("  where application = '" + appid.trim() + "' and system_info='" + sysinfo.trim() + "' and configuration_info='" + configinfo.trim() + "' and instrumentation_info='" + instruinfo.trim() + "' and compiler_info='" + compilerinfo.trim() + "'; ");
        try {
            ResultSet expId = this.getDB().executeQuery(buf.toString());
            if (!expId.next()) {
                expId.close();
                return null;
            }
            String str = expId.getString(1);
            expId.close();
            return str;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String lookupTrial(String trialTable, String trialid) {
        StringBuffer buf = new StringBuffer();
        buf.append("select distinct id from ");
        buf.append(trialTable);
        buf.append("  where id = " + trialid.trim() + "; ");
        try {
            ResultSet expId = this.getDB().executeQuery(buf.toString());
            if (!expId.next()) {
                expId.close();
                return null;
            }
            String str = expId.getString(1);
            expId.close();
            return str;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String insertExp(String exptable, String appid, String sys, String config, String compiler, String instru, String defValue) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append("insert into ");
            buf.append("experiment ");
            if (defValue == null) {
                buf.append(" (application, system_info, configuration_info, instrumentation_info, compiler_info)");
            } else {
                buf.append(" (application, system_info, configuration_info, instrumentation_info, compiler_info, trial_table_name)");
            }
            buf.append(" values ");
            if (defValue == null) {
                buf.append("(" + appid + ", '" + sys + "', '" + config + "', '" + instru + "', '" + compiler + "'); ");
            } else {
                buf.append("(" + appid + ", '" + sys + "', '" + config + "', '" + instru + "', '" + compiler + "', '" + defValue + "'); ");
            }
            this.getDB().executeUpdate(buf.toString());
            buf.delete(0, buf.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                buf.append("select LAST_INSERT_ID();");
            } else {
                buf.append("select currval('experiment_id_seq');");
            }
            String expid = this.getDB().getDataItem(buf.toString());
            System.out.println("The ID for the experiment is: " + expid);
            return expid;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getProblemString(String problemFile) {
        if (problemFile == null) {
            return new String("");
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(problemFile));
        }
        catch (Exception e) {
            System.out.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer problemString = new StringBuffer();
        while (true) {
            String line;
            try {
                line = reader.readLine();
            }
            catch (Exception e) {
                line = null;
            }
            if (line == null) break;
            problemString.append(line.replaceAll("'", "'"));
        }
        try {
            reader.close();
        }
        catch (Exception e) {}
        return problemString.toString();
    }
}

