/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import jargs.gnu.CmdLineParser;
import perfdb.ConnectionManager;
import perfdb.loadxml.Load;
import perfdb.util.dbinterface.DB;

public class LoadApplication {
    private Load load = null;
    private DB db = null;
    private static String APP_USAGE = "USAGE: perfdb_loadapp [{-h,--help}] [{-x,--xmlfile} filename] \n";
    private ConnectionManager connector;

    public LoadApplication(String configFileName) {
        this.connector = new ConnectionManager(configFileName);
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public Load getLoad() {
        if (this.load == null) {
            this.load = this.connector.getDB() == null ? new Load(this.connector.getParserClass()) : new Load(this.connector.getDB(), this.connector.getParserClass());
        }
        return this.load;
    }

    public String storeApp(String appFile) {
        String appid = null;
        try {
            appid = this.getLoad().parseApp(appFile);
        }
        catch (Throwable ex) {
            System.out.println("Error: " + ex.getMessage());
            return null;
        }
        if (appid == null || appid.trim().length() == 0) {
            System.out.println("Loadding application failed");
            return null;
        }
        return appid;
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option xmlfileOpt = parser.addStringOption('x', "xmlfile");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(APP_USAGE);
            System.exit(-1);
        }
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String xmlFile = (String)parser.getOptionValue(xmlfileOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(APP_USAGE);
            System.exit(-1);
        }
        if (configFile == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(APP_USAGE);
            System.exit(-1);
        }
        if (xmlFile == null) {
            System.err.println("Please enter a valid application XML file.");
            System.err.println(APP_USAGE);
            System.exit(-1);
        }
        LoadApplication loadApp = new LoadApplication(configFile);
        loadApp.getConnector().connect();
        int exitval = 0;
        String appid = loadApp.storeApp(xmlFile);
        if (appid != null) {
            exitval = Integer.parseInt(appid);
        }
        loadApp.getConnector().dbclose();
        System.exit(exitval);
    }
}

