/*
 * Decompiled with CFR 0.152.
 */
package perfdb.loadxml;

import jargs.gnu.CmdLineParser;
import perfdb.ConnectionManager;
import perfdb.loadxml.Load;
import perfdb.util.dbinterface.DB;

public class LoadExperiment {
    private Load load = null;
    private DB db = null;
    private static String EXP_USAGE = "USAGE: LoadExperiment [{-h,--help}] [{-a,--applicationid} value] [{-x,--xmlfile} filename]\n";
    private ConnectionManager connector;

    public LoadExperiment(String configFileName) {
        this.connector = new ConnectionManager(configFileName);
    }

    public ConnectionManager getConnector() {
        return this.connector;
    }

    public Load getLoad() {
        if (this.load == null) {
            this.load = this.connector.getDB() == null ? new Load(this.connector.getParserClass()) : new Load(this.connector.getDB(), this.connector.getParserClass());
        }
        return this.load;
    }

    public String storeExp(String appid, String expFile) {
        String expid = null;
        try {
            expid = this.getLoad().parseExp(expFile, appid);
        }
        catch (Throwable ex) {
            System.out.println("Error: " + ex.getMessage());
            return null;
        }
        if (expid == null || expid.trim().length() == 0) {
            System.out.println("Loadding experiment failed");
            return null;
        }
        return expid;
    }

    public static void main(String[] args) {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
        CmdLineParser.Option configfileOpt = parser.addStringOption('g', "configfile");
        CmdLineParser.Option xmlfileOpt = parser.addStringOption('x', "xmlfile");
        CmdLineParser.Option applicationidOpt = parser.addStringOption('a', "applicationid");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        Boolean help = (Boolean)parser.getOptionValue(helpOpt);
        String configFile = (String)parser.getOptionValue(configfileOpt);
        String xmlFile = (String)parser.getOptionValue(xmlfileOpt);
        String applicationID = (String)parser.getOptionValue(applicationidOpt);
        if (help != null && help.booleanValue()) {
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (configFile == null) {
            System.err.println("Please enter a valid config file.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (applicationID == null) {
            System.err.println("Please enter a valid application ID.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        if (xmlFile == null) {
            System.err.println("Please enter a valid experiment XML file.");
            System.err.println(EXP_USAGE);
            System.exit(-1);
        }
        LoadExperiment loadExp = new LoadExperiment(configFile);
        loadExp.getConnector().connect();
        int exitval = 0;
        String expid = loadExp.storeExp(applicationID, xmlFile);
        if (expid != null) {
            exitval = Integer.parseInt(expid);
        }
        loadExp.getConnector().dbclose();
        System.exit(exitval);
    }
}

