/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class LoadTrialPanel
extends JFrame
implements ActionListener {
    ParaProfManager paraProfManager = null;
    ParaProfApplication application = null;
    ParaProfExperiment experiment = null;
    boolean dBTrial = false;
    JTextField dirLocationField = new JTextField(System.getProperty("user.dir"), 30);
    String[] trialTypeStrings = new String[]{"tau profiles", "pprof"};
    JComboBox trialTypes = new JComboBox<String>(this.trialTypeStrings);

    public LoadTrialPanel(ParaProfManager paraProfManager, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, boolean bl) {
        this.paraProfManager = paraProfManager;
        this.application = paraProfApplication;
        this.experiment = paraProfExperiment;
        this.dBTrial = bl;
        int n = 400;
        int n2 = 200;
        Point point = paraProfManager.getLocationOnScreen();
        Dimension dimension = paraProfManager.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        this.setLocation(n5, n6);
        this.setSize(new Dimension(n, n2));
        this.setTitle("Load Trial");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadTrialPanel.this.thisWindowClosing(windowEvent);
            }
        });
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Trial Type"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.trialTypes, gridBagConstraints, 1, 0, 1, 1);
        JButton jButton = new JButton("Dir. Location");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.dirLocationField, gridBagConstraints, 1, 1, 2, 1);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
        jButton = new JButton("Ok");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 2, 2, 1, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Dir. Location")) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    System.out.println("File selection cancelled by user!");
                    return;
                }
                this.dirLocationField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            } else if (string.equals("Cancel")) {
                this.closeThisWindow();
            } else if (string.equals("Ok")) {
                this.paraProfManager.addTrial(this.application, this.experiment, new File(this.dirLocationField.getText().trim()), null, this.trialTypes.getSelectedIndex());
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"LTP02");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"LTP03");
        }
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        this.setVisible(false);
        this.dispose();
    }
}

