/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.UserEvent;

public class UserEventProfile {
    private UserEvent userEvent = null;
    private double numEvents;
    private double minValue;
    private double maxValue;
    private double meanValue;
    private double sumSqr;
    private double stdDev;

    public UserEventProfile(UserEvent userEvent) {
        this.userEvent = userEvent;
    }

    public UserEvent getUserEvent() {
        return this.userEvent;
    }

    public void updateMax() {
        if (this.numEvents > this.userEvent.getMaxUserEventNumberValue()) {
            this.userEvent.setMaxUserEventNumberValue(this.numEvents);
        }
        if (this.minValue > this.userEvent.getMaxUserEventMinValue()) {
            this.userEvent.setMaxUserEventMinValue(this.minValue);
        }
        if (this.maxValue > this.userEvent.getMaxUserEventMaxValue()) {
            this.userEvent.setMaxUserEventMaxValue(this.maxValue);
        }
        if (this.meanValue > this.userEvent.getMaxUserEventMeanValue()) {
            this.userEvent.setMaxUserEventMeanValue(this.meanValue);
        }
        if (this.sumSqr > this.userEvent.getMaxUserEventSumSquared()) {
            this.userEvent.setMaxUserEventSumSquared(this.sumSqr);
        }
        if (this.stdDev > this.userEvent.getMaxUserEventStdDev()) {
            this.userEvent.setMaxUserEventStdDev(this.stdDev);
        }
    }

    public void setNumSamples(double d) {
        this.numEvents = d;
    }

    public double getNumSamples() {
        return this.numEvents;
    }

    public void setMinValue(double d) {
        this.minValue = d;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMeanValue(double d) {
        this.meanValue = d;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public void setSumSquared(double d) {
        this.sumSqr = d;
        this.stdDev = Math.sqrt(Math.abs(this.sumSqr / this.numEvents - this.meanValue * this.meanValue));
    }

    public double getSumSquared() {
        return this.sumSqr;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(double d) {
        this.stdDev = d;
        this.sumSqr = d * d + this.meanValue * this.meanValue + this.numEvents;
    }
}

