/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.RMIChartData;
import common.RMIPerfExplorerModel;
import common.RMIView;
import edu.uoregon.tau.perfdmf.Experiment;
import edu.uoregon.tau.perfdmf.IntervalEvent;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import server.PerfExplorerServer;

public class ChartData
extends RMIChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;
    private List columnValues = null;
    private StringBuffer buf = null;

    public ChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        super(n);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static ChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        System.out.println("getChartData(" + rMIPerfExplorerModel.toString() + ")...");
        ChartData chartData = new ChartData(rMIPerfExplorerModel, n);
        chartData.doQuery();
        return chartData;
    }

    private void doQuery() {
        PerfExplorerServer.getServer().getControl().WAIT("doQuery");
        Object object = null;
        try {
            Object object2;
            ResultSet resultSet;
            String string = null;
            String string2 = null;
            double d = 0.0;
            double d2 = 0.0;
            String string3 = "";
            int n = -1;
            if (this.dataType == 9) {
                this.columnValues = new ArrayList();
                object = this.buildPreQueryStatement();
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    d2 = resultSet.getDouble(2) * resultSet.getDouble(3) * resultSet.getDouble(4);
                    d = resultSet.getDouble(5);
                    if (this.metricName.toLowerCase().indexOf("time") != -1) {
                        d /= 1000000.0;
                    }
                    if (!string3.equals(string)) {
                        ++n;
                        string3 = string;
                        this.addRow(string);
                    }
                    this.addColumn(n, d2, d);
                    this.columnValues.add(new Double(d2));
                }
                resultSet.close();
                object.close();
            }
            object = this.buildStatement();
            resultSet = object.executeQuery();
            int n2 = 0;
            while (resultSet.next()) {
                string = resultSet.getString(1);
                if (this.dataType == 8 || this.dataType == 10) {
                    d2 = resultSet.getDouble(2);
                    string2 = Double.toString(d2);
                    d = resultSet.getDouble(3);
                } else {
                    d2 = resultSet.getDouble(2) * resultSet.getDouble(3) * resultSet.getDouble(4);
                    string2 = Double.toString(d2);
                    d = resultSet.getDouble(5);
                }
                if (this.metricName.toLowerCase().indexOf("time") != -1 && this.dataType != 0) {
                    d /= 1000000.0;
                }
                if (!string3.equals(string)) {
                    ++n;
                    string3 = string;
                    this.addRow(string);
                    n2 = 0;
                }
                if (this.dataType == 9) {
                    object2 = (Double)this.columnValues.get(n2);
                    while ((Double)object2 < d2) {
                        this.addColumn(n, (Double)object2, 0.0);
                        object2 = (Double)this.columnValues.get(++n2);
                    }
                    ++n2;
                }
                this.addColumn(n, d2, d);
            }
            resultSet.close();
            object.close();
            object = this.buildOtherStatement();
            if (object != null) {
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    string = "other";
                    d2 = resultSet.getDouble(1) * resultSet.getDouble(2) * resultSet.getDouble(3);
                    string2 = Double.toString(d2);
                    d = resultSet.getDouble(4);
                    if (this.metricName.toLowerCase().indexOf("time") != -1 && this.dataType != 0) {
                        d /= 1000000.0;
                    }
                    if (!string3.equals(string)) {
                        ++n;
                        string3 = string;
                        this.addRow(string);
                    }
                    this.addColumn(n, d2, d);
                }
                resultSet.close();
                object.close();
            }
            try {
                if (this.dataType == 4 || this.dataType == 9) {
                    object2 = PerfExplorerServer.getServer().getDB();
                    if (object2.getDBType().compareTo("oracle") == 0) {
                        object = object2.prepareStatement("truncate table working_table");
                        object.execute();
                        object.close();
                    }
                    object = object2.getDBType().compareTo("derby") == 0 || object2.getDBType().compareTo("db2") == 0 ? object2.prepareStatement("drop table SESSION.working_table") : object2.prepareStatement("drop table working_table");
                    object.execute();
                    object.close();
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            if (object != null) {
                System.out.println(object.toString());
            }
            System.out.println(this.buf.toString());
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
        }
        PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
    }

    private PreparedStatement buildStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        this.buf = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0) {
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("select cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append("select ie.name, ");
            }
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append(" ims.exclusive_percentage ");
            this.buf.append("from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie ");
            this.buf.append("on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and ims.exclusive_percentage > ");
            this.buf.append(this.model.getXPercent());
            this.buf.append(" and (ie.group_name is null or (");
            this.buf.append("ie.group_name not like '%TAU_CALLPATH%' ");
            this.buf.append("and ie.group_name not like '%TAU_PHASE%')");
            this.buf.append("or ims.exclusive_percentage = 100.0) ");
            this.buf.append("order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 1) {
            List list = this.model.getMultiSelection();
            this.buf.append("select ");
            StringBuffer stringBuffer = new StringBuffer();
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(this.model.getViewSelectionString(dB.getDBType()));
                } else {
                    stringBuffer.append(this.groupByColumn);
                }
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append("cast (e.name as varchar(256))");
            } else {
                stringBuffer.append("e.name");
            }
            this.buf.append(" " + stringBuffer.toString() + ", ");
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append("avg(ims.inclusive) from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("inner join experiment e on t.experiment = e.id ");
                this.buf.append("where t.experiment in (");
                if (list == null) {
                    this.buf.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            this.buf.append(",");
                        }
                        this.buf.append(experiment.getID());
                    }
                }
                this.buf.append(")");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? and ims.inclusive_percentage = 100.0 ");
            } else {
                this.buf.append(" and m.name = ? and ims.inclusive_percentage = 100.0 ");
            }
            this.buf.append(" group by ");
            this.buf.append(stringBuffer.toString());
            this.buf.append(", t.node_count, t.contexts_per_node, t.threads_per_context ");
            this.buf.append("order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 3) {
            this.buf.append("select ");
            StringBuffer stringBuffer = new StringBuffer();
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString(dB.getDBType()) + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" cast (e.name as varchar(256)), ");
            } else {
                stringBuffer.append(" e.name, ");
            }
            this.buf.append(stringBuffer.toString());
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                this.buf.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            this.buf.append("inner join experiment e on t.experiment = e.id ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, false, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    this.buf.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            this.buf.append(",");
                        }
                        this.buf.append(experiment.getID());
                    }
                }
                this.buf.append(") ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
                this.buf.append(" and ie.group_name like ? group by ");
            } else {
                this.buf.append(" and m.name = ? ");
                this.buf.append(" and ie.group_name = ? group by ");
            }
            this.buf.append(stringBuffer.toString());
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("cast (ie.group_name as varchar(256)) order by 1, 2, 3, 4");
            } else {
                this.buf.append("ie.group_name order by 1, 2, 3, 4");
            }
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.groupName);
        } else if (this.dataType == 4 || this.dataType == 9) {
            String string;
            if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("create global temporary table working_table ");
                this.buf.append("(name varchar2(4000)) ");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("declare global temporary table working_table ");
                this.buf.append("(name varchar(4000)) on commit preserve rows not logged ");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("declare global temporary table working_table ");
                this.buf.append("(name varchar(256)) on commit preserve rows not logged ");
            } else {
                this.buf.append("create temporary table working_table (name text) ");
            }
            try {
                preparedStatement = dB.prepareStatement(this.buf.toString());
                preparedStatement.execute();
                preparedStatement.close();
            }
            catch (Exception exception) {
                if (preparedStatement != null) {
                    System.out.println(preparedStatement.toString());
                }
                System.out.println(this.buf.toString());
                string = "ERROR: Couldn't select the analysis settings from the database!";
                System.out.println(string);
                exception.printStackTrace();
            }
            this.buf = new StringBuffer();
            this.buf.append("insert into ");
            if (dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("SESSION.");
            }
            this.buf.append("working_table (select distinct ");
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("cast (ie.name as varchar(256)) ");
            } else {
                this.buf.append("ie.name ");
            }
            this.buf.append("from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and ims.exclusive_percentage > ");
            this.buf.append(this.model.getXPercent());
            this.buf.append(" and (ie.group_name is null or (");
            this.buf.append("ie.group_name not like '%TAU_CALLPATH%' ");
            this.buf.append("and ie.group_name not like '%TAU_PHASE%')");
            this.buf.append("or ims.exclusive_percentage = 100.0) ");
            this.buf.append("and ims.inclusive_percentage < 100.0) ");
            try {
                preparedStatement = dB.prepareStatement(this.buf.toString());
                preparedStatement.setString(1, this.metricName);
                preparedStatement.execute();
                preparedStatement.close();
            }
            catch (Exception exception) {
                System.out.println(preparedStatement.toString());
                System.out.println(this.buf.toString());
                string = "ERROR: Couldn't select the analysis settings from the database!";
                System.out.println(string);
                exception.printStackTrace();
            }
            this.buf = new StringBuffer();
            this.buf.append("select distinct ");
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append(" ie.name, ");
            }
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            if (this.dataType == 9) {
                if (dB.getDBType().compareTo("oracle") == 0) {
                    this.buf.append("ims.excl from interval_mean_summary ims ");
                } else {
                    this.buf.append("ims.exclusive from interval_mean_summary ims ");
                }
            } else if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("ims.excl from interval_mean_summary ims ");
            } else {
                this.buf.append("ims.exclusive from interval_mean_summary ims ");
            }
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            this.buf.append("inner join ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("SESSION.");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("SESSION.working_table w on w.name = cast (ie.name as varchar(256)) ");
            } else {
                this.buf.append("working_table w on w.name = ie.name ");
            }
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append(" order by 1, 2, 3, 4 ");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 5) {
            this.buf.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    this.buf.append(" " + this.model.getViewSelectionString(dB.getDBType()) + ", ");
                } else {
                    this.buf.append(" " + this.groupByColumn + ", ");
                }
            } else if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" cast (e.name as varchar(256)), ");
            } else {
                this.buf.append(" e.name, ");
            }
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append("exclusive from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("inner join experiment e on t.experiment = e.id ");
                this.buf.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    this.buf.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            this.buf.append(",");
                        }
                        this.buf.append(experiment.getID());
                    }
                }
                this.buf.append(") ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
                this.buf.append("and ie.name like ? order by 1, 2, 3, 4");
            } else {
                this.buf.append(" and m.name = ? ");
                this.buf.append("and ie.name = ? order by 1, 2, 3, 4");
            }
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.eventName);
        } else if (this.dataType == 6) {
            this.buf.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append(" cast (ie.name as varchar(256)), ");
                    } else {
                        this.buf.append(" ie.name, ");
                    }
                } else {
                    this.buf.append(" " + this.groupByColumn + ", ");
                }
            } else if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append(" ie.name, ");
            }
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append("ims.inclusive from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ? ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append(" and ie.group_name like '%TAU_PHASE%' order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            if (object instanceof RMIView) {
                preparedStatement.setString(1, this.metricName);
            } else {
                preparedStatement.setInt(1, this.model.getExperiment().getID());
                preparedStatement.setString(2, this.metricName);
            }
        } else if (this.dataType == 7 || this.dataType == 9) {
            this.buf.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    if (dB.getDBType().compareTo("db2") == 0) {
                        this.buf.append(" cast (ie.name as varchar(256)), ");
                    } else {
                        this.buf.append(" ie.name, ");
                    }
                } else {
                    this.buf.append(" " + this.groupByColumn + ", ");
                }
            } else if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append(" ie.name, ");
            }
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append("ims.inclusive_percentage from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            preparedStatement = null;
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and ims.inclusive_percentage < 100.0 ");
            this.buf.append("and ie.group_name like '%TAU_PHASE%' order by 1, 2, 3, 4");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 8) {
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("select cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append("select ie.name, ");
            }
            this.buf.append("(p.node * t.contexts_per_node * ");
            this.buf.append("t.threads_per_context) + (p.context * ");
            this.buf.append("t.threads_per_context) + p.thread as thread, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("p.excl ");
            } else {
                this.buf.append("p.exclusive ");
            }
            this.buf.append("from interval_event ie ");
            this.buf.append("inner join interval_mean_summary s ");
            this.buf.append("on ie.id = s.interval_event and s.exclusive_percentage > ");
            this.buf.append(this.model.getXPercent());
            this.buf.append(" left outer join interval_location_profile p ");
            this.buf.append("on ie.id = p.interval_event ");
            this.buf.append("and p.metric = s.metric ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("where ie.trial = ? ");
            this.buf.append("and p.metric = ? ");
            this.buf.append("and (ie.group_name is null or (");
            this.buf.append("ie.group_name not like '%TAU_CALLPATH%' ");
            this.buf.append("and ie.group_name not like '%TAU_PHASE%')");
            this.buf.append("or s.exclusive_percentage = 100.0) ");
            this.buf.append(" order by 1,2 ");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setInt(1, this.model.getTrial().getID());
            preparedStatement.setInt(2, ((Metric)this.model.getCurrentSelection()).getID());
        } else if (this.dataType == 10) {
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("select cast (ie.name as varchar(256)), ");
            } else {
                this.buf.append("select ie.name, ");
            }
            this.buf.append("(p.node * t.contexts_per_node * ");
            this.buf.append("t.threads_per_context) + (p.context * ");
            this.buf.append("t.threads_per_context) + p.thread as thread, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("p.excl ");
            } else {
                this.buf.append("p.exclusive ");
            }
            this.buf.append("from interval_event ie ");
            this.buf.append(" left outer join interval_location_profile p ");
            this.buf.append("on ie.id = p.interval_event ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("where ie.trial = ? ");
            this.buf.append("and p.metric = ? ");
            this.buf.append("and ie.id in (");
            List list = this.model.getMultiSelection();
            if (list == null) {
                this.buf.append(this.model.getEvent().getID());
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    IntervalEvent intervalEvent = (IntervalEvent)list.get(i);
                    if (i > 0) {
                        this.buf.append(",");
                    }
                    this.buf.append(intervalEvent.getID());
                }
            }
            this.buf.append(") order by 1,2 ");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setInt(1, this.model.getTrial().getID());
            preparedStatement.setInt(2, this.model.getMetric().getID());
        }
        return preparedStatement;
    }

    private PreparedStatement buildOtherStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        this.buf = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0) {
            this.buf.append("select ");
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append("sum(ims.exclusive_percentage) from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie ");
            this.buf.append("on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and ims.inclusive_percentage < 100.0 ");
            this.buf.append("and ims.exclusive_percentage < ");
            this.buf.append(this.model.getXPercent());
            this.buf.append(" and (ie.group_name is null or (");
            this.buf.append("ie.group_name not like '%TAU_CALLPATH%' ");
            this.buf.append("and ie.group_name not like '%TAU_PHASE%')");
            this.buf.append("or ims.exclusive_percentage = 100.0) group by t.node_count, t.contexts_per_node, t.threads_per_context order by 1, 2, 3");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 4) {
            this.buf.append("select ");
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                this.buf.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                this.buf.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            this.buf.append("inner join interval_event ie on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            this.buf.append("left outer join ");
            if (dB.getDBType().compareTo("derby") == 0) {
                this.buf.append("SESSION.");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append("SESSION.working_table w on w.name = cast(ie.name as varchar(256)) ");
            } else {
                this.buf.append("working_table w on w.name = ie.name ");
            }
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and w.name is null ");
            this.buf.append("group by t.node_count, t.contexts_per_node, t.threads_per_context order by 1, 2, 3 ");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        }
        return preparedStatement;
    }

    private PreparedStatement buildPreQueryStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        this.buf = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 9) {
            this.buf.append("select 'TOTAL', ");
            this.buf.append("t.node_count, t.contexts_per_node, t.threads_per_context, ");
            this.buf.append(" max(ims.inclusive) ");
            this.buf.append("from interval_mean_summary ims ");
            this.buf.append("inner join interval_event ie ");
            this.buf.append("on ims.interval_event = ie.id ");
            this.buf.append("inner join trial t on ie.trial = t.id ");
            this.buf.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                this.buf.append(this.model.getViewSelectionPath(true, true, dB.getDBType()));
            } else {
                this.buf.append("where t.experiment = ");
                this.buf.append(this.model.getExperiment().getID() + " ");
            }
            if (dB.getDBType().compareTo("db2") == 0) {
                this.buf.append(" and m.name like ? ");
            } else {
                this.buf.append(" and m.name = ? ");
            }
            this.buf.append("and ims.exclusive_percentage > ");
            this.buf.append(this.model.getXPercent());
            this.buf.append(" and (ie.group_name is null or (");
            this.buf.append("ie.group_name not like '%TAU_CALLPATH%' ");
            this.buf.append("and ie.group_name not like '%TAU_PHASE%')");
            this.buf.append("or ims.exclusive_percentage = 100.0) ");
            this.buf.append("group by t.node_count, t.contexts_per_node, t.threads_per_context order by 2, 3, 4 ");
            preparedStatement = dB.prepareStatement(this.buf.toString());
            preparedStatement.setString(1, this.metricName);
        }
        return preparedStatement;
    }

    private boolean isLeafView() {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = dB.prepareStatement("select table_name, column_name from trial_view where parent = ?");
            preparedStatement.setString(1, this.model.getViewID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                this.groupByColumn = string.equalsIgnoreCase("Application") ? new String("a.") : (string.equalsIgnoreCase("Experiment") ? new String("e.") : new String("t."));
                this.groupByColumn = this.groupByColumn + resultSet.getString(2);
                bl = false;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
        }
        return bl;
    }
}

