/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProf;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class WindowPlacer {
    private static Point lastGlobalDataWindowPosition;
    private static int screenHeight;
    private static int screenWidth;
    private static Point lastLocation;
    private static List visibleWindows;
    private static int lastXOffset;

    static void addToVisibleList(JFrame jFrame) {
        visibleWindows.add(jFrame);
    }

    static void removeFromVisibleList(JFrame jFrame) {
        visibleWindows.remove(jFrame);
    }

    public static Point getGlobalDataWindowPosition(JFrame jFrame) {
        int n = ParaProf.paraProfManagerWindow.getLocation().x;
        int n2 = ParaProf.paraProfManagerWindow.getLocation().y;
        Point point = new Point(n + 75, n2 + 110);
        if (point.equals(lastGlobalDataWindowPosition)) {
            point.translate(25, 25);
        }
        lastGlobalDataWindowPosition = point;
        if (point.x + jFrame.getWidth() > screenWidth) {
            point.setLocation(0, point.y);
        }
        if (point.y + jFrame.getHeight() > screenHeight) {
            point.setLocation(point.x, 0);
        }
        WindowPlacer.sanityCheck(jFrame, point);
        return point;
    }

    private static int getProperXPosition(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        if (component instanceof JFrame && component.getLocation().x >= screenWidth / 2) {
            return screenWidth / 2;
        }
        return 0;
    }

    private static Point getParentLocation(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        if (component instanceof JFrame) {
            return component.getLocation();
        }
        return new Point(WindowPlacer.getProperXPosition(component), 0);
    }

    private static Dimension getParentSize(Component component) {
        while (component != null && !(component instanceof JFrame)) {
            component = component.getParent();
        }
        if (component instanceof JFrame) {
            return component.getSize();
        }
        return new Dimension(50, 50);
    }

    public static void sanityCheck(JFrame jFrame, Point point) {
        int n = point.x;
        int n2 = point.y;
        n = Math.min(n, screenWidth - jFrame.getWidth());
        n = Math.max(n, 0);
        n2 = Math.min(n2, screenHeight - jFrame.getHeight());
        n2 = Math.max(n2, 0);
        point.setLocation(n, n2);
        if (ParaProf.demoMode) {
            point.setLocation(0, 0);
        }
    }

    public static Point getNewLocation(JFrame jFrame, Component component) {
        if (lastLocation == null) {
            lastLocation = new Point(WindowPlacer.getProperXPosition(component), 0);
            WindowPlacer.sanityCheck(jFrame, lastLocation);
            return lastLocation;
        }
        int n = WindowPlacer.getProperXPosition(component) + (lastXOffset += 25);
        int n2 = WindowPlacer.lastLocation.y + 25;
        if (n + jFrame.getWidth() > screenWidth) {
            n = WindowPlacer.getProperXPosition(component);
            n = Math.min(n, screenWidth - jFrame.getWidth());
            n = Math.max(n, 0);
            lastXOffset = 0;
        }
        if (n2 + jFrame.getHeight() > screenHeight) {
            n2 = 0;
        }
        lastLocation = new Point(n, n2);
        WindowPlacer.sanityCheck(jFrame, lastLocation);
        return lastLocation;
    }

    public static Point getNewLedgerLocation(JFrame jFrame, Component component) {
        Point point = WindowPlacer.getParentLocation(component);
        int n = point.x;
        int n2 = point.y + (int)(Math.random() * 50.0);
        point.setLocation(n -= jFrame.getWidth(), n2);
        WindowPlacer.sanityCheck(jFrame, point);
        return point;
    }

    static {
        visibleWindows = new ArrayList();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        screenHeight = dimension.height;
        screenWidth = dimension.width;
    }
}

