/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.Axes;
import edu.uoregon.tau.vis.ColorScale;
import edu.uoregon.tau.vis.Plot;
import edu.uoregon.tau.vis.Vec;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLU;
import net.java.games.jogl.GLUquadric;

public class ScatterPlot
implements Plot {
    private float xSize = 15.0f;
    private float ySize = 15.0f;
    private float zSize = 15.0f;
    private float sphereSize = 0.4f;
    private int sphereDetail = 8;
    private boolean visible = true;
    private boolean normalized = true;
    private float[][] values;
    private ColorScale colorScale;
    private Axes axes;
    private int displayList;
    private boolean dirty = true;
    private GL gl;
    private int selectedRow = 5;
    private int selectedCol = 5;

    public void setSize(float f, float f2, float f3) {
        this.xSize = f;
        this.ySize = f2;
        this.zSize = f3;
        if (this.axes != null) {
            this.axes.setSize(f, f2, f3);
        }
        if (this.values != null) {
            this.processValues();
        }
        this.dirty = true;
    }

    public void setValues(float[][] fArray) {
        this.values = fArray;
        this.processValues();
        this.dirty = true;
    }

    public float getSphereSize() {
        return this.sphereSize;
    }

    public void setSphereSize(float f) {
        this.sphereSize = f;
        this.dirty = true;
    }

    public Axes getAxes() {
        return this.axes;
    }

    public void setAxes(Axes axes) {
        this.axes = axes;
        axes.setSize(this.xSize, this.ySize, this.zSize);
    }

    public int getSphereDetail() {
        return this.sphereDetail;
    }

    public void setSphereDetail(int n) {
        this.sphereDetail = n;
        this.dirty = true;
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale colorScale) {
        if (this.colorScale != null) {
            this.colorScale.deleteObserver(this);
        }
        this.colorScale = colorScale;
        if (colorScale != null) {
            colorScale.addObserver(this);
        }
    }

    public float getWidth() {
        return this.xSize;
    }

    public float getDepth() {
        return this.ySize;
    }

    public float getHeight() {
        return this.zSize;
    }

    public String getName() {
        return "ScatterPlot";
    }

    public void cleanUp() {
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        final JSlider jSlider = new JSlider(0, 20, (int)(this.sphereSize * 10.0f));
        final JSlider jSlider2 = new JSlider(3, 30, this.sphereDetail);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    ScatterPlot.this.setSphereSize((float)jSlider.getValue() / 10.0f);
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        jSlider2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    ScatterPlot.this.setSphereDetail(jSlider2.getValue());
                    visRenderer.redraw();
                }
                catch (Exception exception) {
                    VisTools.handleException(exception);
                }
            }
        });
        VisTools.addCompItem(jPanel, new JLabel("Point size"), gridBagConstraints, 0, 0, 1, 1);
        VisTools.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 0, 1, 1);
        VisTools.addCompItem(jPanel, new JLabel("Point detail"), gridBagConstraints, 0, 1, 1, 1);
        VisTools.addCompItem(jPanel, jSlider2, gridBagConstraints, 1, 1, 1, 1);
        return jPanel;
    }

    public void render(VisRenderer visRenderer) {
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        Vec vec = visRenderer.getViewDirection();
        if (this.axes != null) {
            this.axes.render(visRenderer);
        }
        if (!this.visible) {
            return;
        }
        GL gL = gLDrawable.getGL();
        if (this.dirty || this.displayList == 0) {
            this.displayList = gL.glGenLists(1);
            gL.glNewList(this.displayList, 4864);
            this.privateRender(gLDrawable);
            gL.glEndList();
            this.dirty = false;
        }
        gL.glCallList(this.displayList);
    }

    private void processValues() {
        float[] fArray = new float[]{this.xSize, this.ySize, this.zSize, 1.0f};
        for (int i = 0; i < 4; ++i) {
            int n;
            float f = Float.MIN_VALUE;
            float f2 = Float.MAX_VALUE;
            for (n = 0; n < this.values.length; ++n) {
                f = Math.max(f, this.values[n][i]);
                f2 = Math.min(f2, this.values[n][i]);
            }
            for (n = 0; n < this.values.length; ++n) {
                this.values[n][i] = f - f2 == 0.0f ? 0.0f : (this.normalized ? (this.values[n][i] - f2) / (f - f2) * fArray[i] : this.values[n][i] / f * fArray[i]);
            }
        }
    }

    private void privateRender(GLDrawable gLDrawable) {
        if (this.values == null) {
            return;
        }
        GL gL = gLDrawable.getGL();
        GLU gLU = gLDrawable.getGLU();
        gL.glShadeModel(7425);
        gL.glColor3f(1.0f, 0.0f, 0.0f);
        if (this.sphereSize < 0.1f) {
            gL.glDisable(2896);
            gL.glPointSize(2.5f);
            gL.glBegin(0);
            for (int i = 0; i < this.values.length; ++i) {
                if (this.colorScale != null) {
                    Color color = this.colorScale.getColor(this.values[i][3]);
                    gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
                gL.glVertex3f(this.values[i][0], this.values[i][1], this.values[i][2]);
            }
            gL.glEnd();
        } else {
            gL.glEnable(2896);
            gL.glEnable(2929);
            gL.glFrontFace(2305);
            GLUquadric gLUquadric = gLU.gluNewQuadric();
            gL.glEnable(2884);
            gLU.gluQuadricDrawStyle(gLUquadric, 100012);
            gLU.gluQuadricOrientation(gLUquadric, 100020);
            gLU.gluQuadricNormals(gLUquadric, 100000);
            for (int i = 0; i < this.values.length; ++i) {
                gL.glPushMatrix();
                gL.glTranslatef(this.values[i][0], this.values[i][1], this.values[i][2]);
                if (this.colorScale != null) {
                    Color color = this.colorScale.getColor(this.values[i][3]);
                    gL.glColor3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
                }
                gLU.gluSphere(gLUquadric, (double)this.sphereSize, this.sphereDetail, this.sphereDetail);
                gL.glPopMatrix();
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof ColorScale) {
            this.dirty = true;
        }
    }

    public int getSelectedRow() {
        return this.selectedRow;
    }

    public void setSelectedRow(int n) {
        this.selectedRow = n;
    }

    public int getSelectedCol() {
        return this.selectedCol;
    }

    public void setSelectedCol(int n) {
        this.selectedCol = n;
    }

    public boolean getNormalized() {
        return this.normalized;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }
}

