from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_ver = _Mock()

authors = _Mock()

classifiers = _Mock()

kernel_protocol_version_info = _Mock()

keywords = _Mock()

platforms = _Mock()

version_info = _Mock()

__version__ = '2.3.0'

_version_extra = ''

_version_major = 2

_version_minor = 3

_version_patch = 0

author = 'The IPython Development Team'

author_email = 'ipython-dev@scipy.org'

codename = ''

description = 'IPython: Productive Interactive Computing'

download_url = 'https://github.com/ipython/ipython/downloads'

license = 'BSD'

long_description = "\nIPython provides a rich toolkit to help you make the most out of using Python\ninteractively.  Its main components are:\n\n* Powerful interactive Python shells (terminal- and Qt-based).\n* A web-based interactive notebook environment with all shell features plus\n  support for embedded figures, animations and rich media.\n* Support for interactive data visualization and use of GUI toolkits.\n* Flexible, embeddable interpreters to load into your own projects.\n* A high-performance library for high level and interactive parallel computing\n  that works in multicore systems, clusters, supercomputing and cloud scenarios.\n\nThe enhanced interactive Python shells have the following main features:\n\n* Comprehensive object introspection.\n\n* Input history, persistent across sessions.\n\n* Caching of output results during a session with automatically generated\n  references.\n\n* Extensible tab completion, with support by default for completion of python\n  variables and keywords, filenames and function keywords.\n\n* Extensible system of 'magic' commands for controlling the environment and\n  performing many tasks related either to IPython or the operating system.\n\n* A rich configuration system with easy switching between different setups\n  (simpler than changing $PYTHONSTARTUP environment variables every time).\n\n* Session logging and reloading.\n\n* Extensible syntax processing for special purpose situations.\n\n* Access to the system shell with user-extensible alias system.\n\n* Easily embeddable in other Python programs and GUIs.\n\n* Integrated access to the pdb debugger and the Python profiler.\n\nThe parallel computing architecture has the following main features:\n\n* Quickly parallelize Python code from an interactive Python/IPython session.\n\n* A flexible and dynamic process model that be deployed on anything from\n  multicore workstations to supercomputers.\n\n* An architecture that supports many different styles of parallelism, from\n  message passing to task farming.\n\n* Both blocking and fully asynchronous interfaces.\n\n* High level APIs that enable many things to be parallelized in a few lines\n  of code.\n\n* Share live parallel jobs with other users securely.\n\n* Dynamically load balanced task farming system.\n\n* Robust error handling in parallel code.\n\nThe latest development version is always available from IPython's `GitHub\nsite <http://github.com/ipython>`_.\n"

name = 'ipython'

url = 'http://ipython.org'

version = '2.3.0'



