from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


COLORMAPS = _Mock()

EXTRA_COLORMAPS = _Mock()

FULLRANGE = _Mock()

ICON_CACHE = _Mock()

_cm = _Mock()

_interpolate = _Mock()

_setup_colormap = _Mock()

array = _Mock()

build_icon_from_cmap = _Mock()

build_icon_from_cmap_name = _Mock()

get_cmap = _Mock()

get_cmap_name = _Mock()

get_colormap_list = _Mock()

linspace = _Mock()

newaxis = _Mock()

register_extra_colormap = _Mock()

toQImage = _Mock()

zeros = _Mock()



class QColor(_Mock):
  pass
  Cmyk = 3
  Hsl = 4
  Hsv = 2
  Invalid = 0
  Rgb = 1

class QIcon(_Mock):
  pass
  Active = 2
  Disabled = 1
  Normal = 0
  Off = 1
  On = 0
  Selected = 3

class QPixmap(_Mock):
  pass
  ExplicitlyShared = 1
  ImplicitlyShared = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QwtDoubleInterval(_Mock):
  pass
  ExcludeBorders = 3
  ExcludeMaximum = 2
  ExcludeMinimum = 1
  IncludeBorders = 0

class QwtLinearColorMap(_Mock):
  pass
  FixedColors = 0
  Indexed = 1
  RGB = 0
  ScaledColors = 1

class uint8(_Mock):
  pass


