from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


base_flags = _Mock()

create_flags = _Mock()

get_ipython_dir = _Mock()

get_ipython_package_dir = _Mock()

import_item = _Mock()

list_bundled_profiles = _Mock()

list_profiles_in = _Mock()

os = _Mock()

print_function = _Mock()

py3compat = _Mock()

_create_examples = '\nipython profile create foo         # create profile foo w/ default config files\nipython profile create foo --reset # restage default config files over current\nipython profile create foo --parallel # also stage parallel config files\n'

_list_examples = 'ipython profile list  # list all profiles'

_main_examples = "\nipython profile create -h  # show the help string for the create subcommand\nipython profile list -h    # show the help string for the list subcommand\n\nipython locate profile foo # print the path to the directory for profile 'foo'\n"

create_help = "Create an IPython profile by name\n\nCreate an ipython profile directory by its name or\nprofile directory path. Profile directories contain\nconfiguration, log and security related files and are named\nusing the convention 'profile_<name>'. By default they are\nlocated in your ipython directory. Once created, you will\ncan edit the configuration files in the profile\ndirectory to configure IPython. Most users will create a\nprofile directory by name,\n`ipython profile create myprofile`, which will put the directory\nin `<ipython_dir>/profile_myprofile`.\n"

list_help = "List available IPython profiles\n\nList all available profiles, by profile location, that can\nbe found in the current working directly or in the ipython\ndirectory. Profile directories are named using the convention\n'profile_<profile>'.\n"

profile_help = "Manage IPython profiles\n\nProfile directories contain\nconfiguration, log and security related files and are named\nusing the convention 'profile_<name>'. By default they are\nlocated in your ipython directory.  You can create profiles\nwith `ipython profile create <name>`, or see the profiles you\nalready have with `ipython profile list`\n\nTo get started configuring IPython, simply do:\n\n$> ipython profile create\n\nand IPython will create the default profile in <ipython_dir>/profile_default,\nwhere you can edit ipython_config.py to start configuring IPython.\n\n"

class Application(_Mock):
  pass


class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Dict(_Mock):
  pass
  info_text = 'any value'

class ProfileApp(_Mock):
  pass
  description = "Manage IPython profiles\n\nProfile directories contain\nconfiguration, log and security related files and are named\nusing the convention 'profile_<name>'. By default they are\nlocated in your ipython directory.  You can create profiles\nwith `ipython profile create <name>`, or see the profiles you\nalready have with `ipython profile list`\n\nTo get started configuring IPython, simply do:\n\n$> ipython profile create\n\nand IPython will create the default profile in <ipython_dir>/profile_default,\nwhere you can edit ipython_config.py to start configuring IPython.\n\n"
  examples = "\nipython profile create -h  # show the help string for the create subcommand\nipython profile list -h    # show the help string for the list subcommand\n\nipython locate profile foo # print the path to the directory for profile 'foo'\n"
  name = u'ipython-profile'

class ProfileCreate(_Mock):
  pass
  _in_init_profile_dir = False
  description = "Create an IPython profile by name\n\nCreate an ipython profile directory by its name or\nprofile directory path. Profile directories contain\nconfiguration, log and security related files and are named\nusing the convention 'profile_<name>'. By default they are\nlocated in your ipython directory. Once created, you will\ncan edit the configuration files in the profile\ndirectory to configure IPython. Most users will create a\nprofile directory by name,\n`ipython profile create myprofile`, which will put the directory\nin `<ipython_dir>/profile_myprofile`.\n"
  examples = '\nipython profile create foo         # create profile foo w/ default config files\nipython profile create foo --reset # restage default config files over current\nipython profile create foo --parallel # also stage parallel config files\n'
  name = u'ipython-profile'

class ProfileDir(_Mock):
  pass


class ProfileList(_Mock):
  pass
  description = "List available IPython profiles\n\nList all available profiles, by profile location, that can\nbe found in the current working directly or in the ipython\ndirectory. Profile directories are named using the convention\n'profile_<profile>'.\n"
  examples = 'ipython profile list  # list all profiles'
  name = u'ipython-profile'

class ProfileLocate(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'print the path to an IPython profile dir'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

