from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


DONE = _Mock()

cPickle = _Mock()

compare_digest = _Mock()

date_default = _Mock()

default_packer = _Mock()

default_secure = _Mock()

default_unpacker = _Mock()

extract_dates = _Mock()

extract_header = _Mock()

hashlib = _Mock()

hmac = _Mock()

import_item = _Mock()

io = _Mock()

iteritems = _Mock()

json_packer = _Mock()

json_unpacker = _Mock()

jsonapi = _Mock()

logging = _Mock()

msg_header = _Mock()

os = _Mock()

pickle = _Mock()

pickle_packer = _Mock()

pickle_unpacker = _Mock()

pprint = _Mock()

random = _Mock()

session_aliases = _Mock()

session_flags = _Mock()

squash_dates = _Mock()

squash_unicode = _Mock()

str_to_bytes = _Mock()

str_to_unicode = _Mock()

test_msg2obj = _Mock()

uuid = _Mock()

zmq = _Mock()

DELIM = '<IDS|MSG>'

MAX_BYTES = 1024

MAX_ITEMS = 64

PICKLE_PROTOCOL = 2

class Any(_Mock):
  pass
  info_text = 'any value'

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CBytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class CUnicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class Configurable(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class IOLoop(_Mock):
  pass
  ERROR = 24
  NONE = 0
  READ = 1
  WRITE = 4
  _EPOLLERR = 8
  _EPOLLET = 2147483648
  _EPOLLHUP = 16
  _EPOLLIN = 1
  _EPOLLONESHOT = 1073741824
  _EPOLLOUT = 4
  _EPOLLPRI = 2
  _EPOLLRDHUP = 8192

class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class LoggingConfigurable(_Mock):
  pass


class Message(_Mock):
  pass


class Session(_Mock):
  pass


class SessionFactory(_Mock):
  pass


class Set(_Mock):
  pass
  info_text = 'any value'

class TraitError(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ZMQStream(_Mock):
  pass


class datetime(_Mock):
  pass


class unicode_type(_Mock):
  pass


