from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_default_compilers = _Mock()

_f77flags_re = _Mock()

_find_existing_fcompiler = _Mock()

_free_f90_start = _Mock()

_has_f90_header = _Mock()

_has_f_header = _Mock()

_has_fix_header = _Mock()

absolute_import = _Mock()

all_strings = _Mock()

available_fcompilers_for_platform = _Mock()

division = _Mock()

dummy_fortran_file = _Mock()

fcompiler_aliases = _Mock()

fcompiler_class = _Mock()

find_executable = _Mock()

flaglist = _Mock()

gen_lib_options = _Mock()

get_default_fcompiler = _Mock()

get_exception = _Mock()

get_f77flags = _Mock()

get_python_lib = _Mock()

get_shared_lib_extension = _Mock()

has_f90_header = _Mock()

is_f_file = _Mock()

is_free_format = _Mock()

is_sequence = _Mock()

is_sequence_of_strings = _Mock()

is_string = _Mock()

load_all_fcompiler_classes = _Mock()

log = _Mock()

make_temp_file = _Mock()

new_fcompiler = _Mock()

open_latin1 = _Mock()

os = _Mock()

print_function = _Mock()

re = _Mock()

show_fcompilers = _Mock()

split_quoted = _Mock()

str2bool = _Mock()

strtobool = _Mock()

sys = _Mock()

types = _Mock()

failed_fcompiler = _Mock()

class CCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'

class CompileError(_Mock):
  pass


class CompilerNotFound(_Mock):
  pass


class DistutilsExecError(_Mock):
  pass


class DistutilsModuleError(_Mock):
  pass


class DistutilsPlatformError(_Mock):
  pass


class EnvironmentConfig(_Mock):
  pass


class FCompiler(_Mock):
  pass
  EXECUTABLE = 'executable'
  SHARED_LIBRARY = 'shared_library'
  SHARED_OBJECT = 'shared_object'
  compile_switch = '-c'
  exe_extension = ''
  library_switch = '-o '
  module_include_switch = '-I'
  obj_extension = '.o'
  object_switch = '-o '
  shared_lib_extension = '.so'
  shared_lib_format = '%s%s'
  static_lib_extension = '.a'
  static_lib_format = 'lib%s%s'

class FancyGetopt(_Mock):
  pass


class LinkError(_Mock):
  pass


