from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


DEV = _Mock()

SIGNAL = _Mock()

_ = _Mock()

action2button = _Mock()

add_actions = _Mock()

create_action = _Mock()

create_toolbutton = _Mock()

get_icon = _Mock()

is_text_string = _Mock()

main = _Mock()

sys = _Mock()

to_text_string = _Mock()



class FindReplace(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QHBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class QLabel(_Mock):
  pass
  AlignCenter = 132
  AlignRight = 2
  AlignVCenter = 128
  Box = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  HLine = 4
  IgnoreMask = 4
  NoFrame = 0
  Panel = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Plain = 16
  Raised = 32
  Shadow_Mask = 240
  Shape_Mask = 15
  StyledPanel = 6
  Sunken = 48
  VLine = 5
  WinPanel = 3

class QMenu(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QProgressBar(_Mock):
  pass
  BottomToTop = 1
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  TopToBottom = 0

class QUrl(_Mock):
  pass
  RemoveAuthority = 30
  RemoveFragment = 128
  RemovePassword = 2
  RemovePath = 32
  RemovePort = 8
  RemoveQuery = 64
  RemoveScheme = 1
  RemoveUserInfo = 6
  StrictMode = 1
  StripTrailingSlash = 65536
  TolerantMode = 0

class QVBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class QWebPage(_Mock):
  pass
  AlignCenter = 63
  AlignJustified = 64
  AlignLeft = 65
  AlignRight = 66
  Back = 8
  ChooseMultipleFilesExtension = 0
  Copy = 13
  CopyImageToClipboard = 7
  CopyImageUrlToClipboard = 68
  CopyLinkToClipboard = 4
  Cut = 12
  DelegateAllLinks = 2
  DelegateExternalLinks = 1
  DeleteEndOfWord = 42
  DeleteStartOfWord = 41
  DontDelegateLinks = 0
  DownloadImageToDisk = 6
  DownloadLinkToDisk = 3
  ErrorPageExtension = 1
  FindBackward = 1
  FindCaseSensitively = 2
  FindWrapsAroundDocument = 4
  Forward = 9
  Geolocation = 1
  HighlightAllOccurrences = 8
  Http = 1
  Indent = 61
  InsertLineSeparator = 51
  InsertOrderedList = 60
  InsertParagraphSeparator = 50
  InsertUnorderedList = 59
  InspectElement = 49
  MoveToEndOfBlock = 26
  MoveToEndOfDocument = 28
  MoveToEndOfLine = 24
  MoveToNextChar = 17
  MoveToNextLine = 21
  MoveToNextWord = 19
  MoveToPreviousChar = 18
  MoveToPreviousLine = 22
  MoveToPreviousWord = 20
  MoveToStartOfBlock = 25
  MoveToStartOfDocument = 27
  MoveToStartOfLine = 23
  NavigationTypeBackOrForward = 2
  NavigationTypeFormResubmitted = 4
  NavigationTypeFormSubmitted = 1
  NavigationTypeLinkClicked = 0
  NavigationTypeOther = 5
  NavigationTypeReload = 3
  NoWebAction = -1
  Notifications = 0
  OpenFrameInNewWindow = 2
  OpenImageInNewWindow = 5
  OpenLink = 0
  OpenLinkInNewWindow = 1
  Outdent = 62
  Paste = 14
  PasteAndMatchStyle = 54
  PermissionDeniedByUser = 2
  PermissionGrantedByUser = 1
  PermissionUnknown = 0
  QtNetwork = 0
  Redo = 16
  Reload = 11
  ReloadAndBypassCache = 53
  RemoveFormat = 55
  SelectAll = 52
  SelectEndOfBlock = 38
  SelectEndOfDocument = 40
  SelectEndOfLine = 36
  SelectNextChar = 29
  SelectNextLine = 33
  SelectNextWord = 31
  SelectPreviousChar = 30
  SelectPreviousLine = 34
  SelectPreviousWord = 32
  SelectStartOfBlock = 37
  SelectStartOfDocument = 39
  SelectStartOfLine = 35
  SetTextDirectionDefault = 43
  SetTextDirectionLeftToRight = 44
  SetTextDirectionRightToLeft = 45
  Stop = 10
  StopScheduledPageRefresh = 67
  ToggleBold = 46
  ToggleItalic = 47
  ToggleStrikethrough = 56
  ToggleSubscript = 57
  ToggleSuperscript = 58
  ToggleUnderline = 48
  Undo = 15
  WebBrowserWindow = 0
  WebKit = 2
  WebModalDialog = 1

class QWebSettings(_Mock):
  pass
  AcceleratedCompositingEnabled = 17
  AutoLoadImages = 0
  CursiveFont = 4
  DefaultFixedFontSize = 3
  DefaultFontSize = 2
  DefaultFrameIconGraphic = 2
  DeveloperExtrasEnabled = 7
  DnsPrefetchEnabled = 15
  FantasyFont = 5
  FixedFont = 1
  FrameFlatteningEnabled = 21
  HyperlinkAuditingEnabled = 26
  InputSpeechButtonGraphic = 5
  JavaEnabled = 2
  JavascriptCanAccessClipboard = 6
  JavascriptCanCloseWindows = 23
  JavascriptCanOpenWindows = 5
  JavascriptEnabled = 1
  LinksIncludedInFocusChain = 8
  LocalContentCanAccessFileUrls = 19
  LocalContentCanAccessRemoteUrls = 14
  LocalStorageDatabaseEnabled = 13
  LocalStorageEnabled = 13
  MinimumFontSize = 0
  MinimumLogicalFontSize = 1
  MissingImageGraphic = 0
  MissingPluginGraphic = 1
  OfflineStorageDatabaseEnabled = 11
  OfflineWebApplicationCacheEnabled = 12
  PluginsEnabled = 3
  PrintElementBackgrounds = 10
  PrivateBrowsingEnabled = 4
  SansSerifFont = 3
  SearchCancelButtonGraphic = 6
  SearchCancelButtonPressedGraphic = 7
  SerifFont = 2
  SiteSpecificQuirksEnabled = 22
  SpatialNavigationEnabled = 18
  StandardFont = 0
  TextAreaSizeGripCornerGraphic = 3
  TiledBackingStoreEnabled = 20
  WebGLEnabled = 24
  XSSAuditingEnabled = 16
  ZoomTextOnly = 9

class QWebView(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QWidget(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class UrlComboBox(_Mock):
  pass
  AdjustToContents = 0
  AdjustToContentsOnFirstShow = 1
  AdjustToMinimumContentsLength = 2
  AdjustToMinimumContentsLengthWithIcon = 3
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  InsertAfterCurrent = 4
  InsertAlphabetically = 6
  InsertAtBottom = 3
  InsertAtCurrent = 2
  InsertAtTop = 1
  InsertBeforeCurrent = 5
  NoInsert = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class WebBrowser(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class WebView(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

