/* Copyright(C) 2004,05 Stefan Siegl <ssiegl@gmx.de>
 * taxbird - free program to interface with German IRO's Elster/Coala
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <geier.h>

#include "interface.h"
#include "support.h"
#include "workspace.h"
#include "guile.h"
#include "console.h"


/* forwarded main, i.e. with guile support initialized */
static void main_forward(void *closure, int argc, char **argv);

/* whether we're using the console interface or the common gui */
static int taxbird_enable_console = 0;

int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  /* scan argument list for `--console' flag before we pass control
   * to the gnome cruft ...
   */
  char **ptr = argv;
  if(*ptr) do
    if(! strcmp(*ptr, "--console")) {
      do ptr[0] = ptr[1]; while(* (++ ptr));
      argc --;
      taxbird_enable_console = 1;
      break;
    }
  while(* (++ ptr));

  if(! taxbird_enable_console)
    gnome_program_init (PACKAGE_NAME, PACKAGE_VERSION, LIBGNOMEUI_MODULE,
			argc, argv,
			GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
			NULL);

  /* initialize GEIER library */
  geier_init(0); /* don't create debug output */

  /* initialize Guile backend */
  scm_boot_guile(argc, argv, main_forward, NULL);

  /* leaving taxbird, deinitialize libgeier */
  geier_exit();

  return 0;
}



/* forwarded main, i.e. with guile support initialized */
static void
main_forward(void *closure, int argc, char **argv) 
{
  /* keep GCC from complaining that 'closure' is not used */
  (void) closure;

  /* TODO parse command line arguments, left for us ... 
   * Especially read the name of a file we should open right after startup.
   * Some output Elster-XML command like Glade's compile instruction would
   * be cool as well */
  (void) argc;
  (void) argv;

  SCM main_forward_bootstrap(void *body_data) {
    (void) body_data;

    /* load taxbird's Guile extension stuff */
    taxbird_guile_init();

    if(taxbird_enable_console)
      taxbird_console_init();

    taxbird_guile_eval_file("startup.scm");

    if(!taxbird_enable_console) {
      /* create initial application window, i.e. workspace(ws) */
      GtkWidget *appwin = taxbird_ws_new();
      if(! appwin) exit(1); /* abort start */
      
      if(argc == 2)
	taxbird_ws_open(appwin, argv[1]);
    }

    return SCM_BOOL(0);
  }

  if(SCM_NFALSEP(scm_internal_stack_catch(SCM_BOOL(1),
					  main_forward_bootstrap, NULL,
					  taxbird_guile_global_err_handler,
					  NULL)))
    exit(1); /* abort */



  SCM main_forward_catchy(void *body_data) {
    (void) body_data;

    if(taxbird_enable_console) {
      printf("*** Taxbird Console Interface ***\n");
      gh_repl(argc, argv);
    }
    else 
      gtk_main (); /* run common application */

    return SCM_BOOL(0);
  }

  while(SCM_NFALSEP(scm_internal_stack_catch(SCM_BOOL(1),
					     main_forward_catchy, NULL,
					     taxbird_guile_global_err_handler,
					     NULL)));
}

