[comment {-*- tcl -*- doctools manpage}]
[manpage_begin smtp n 1.3.6]
[copyright {1999-2000 Marshall T. Rose}]
[moddesc   {smtp client}]
[titledesc {Client-side tcl implementation of the smtp protocol}]
[require Tcl]
[require mime [opt 1.3.6]]
[require smtp [opt 1.3.6]]
[description]
[para]

The [package smtp] library package provides the client side of the
smtp protocol.

[list_begin definitions]

[call [cmd ::smtp::sendmessage] [arg token] [arg option]...]

This command sends the MIME part (see package [package mime])
represented by [arg token] to an SMTP server. [arg options] is a list
of options and their associated values.  The recognized options are:

[list_begin definitions]

[lst_item [option -servers]]

A list of SMTP servers. The default is [const localhost].

[lst_item [option -ports]]

A list of SMTP ports. The default is [const 25].

[lst_item [option -queue]]

Indicates that the SMTP server should be asked to queue the message
for later processing. A boolean value.

[lst_item [option -atleastone]]

Indicates that the SMTP server must find at least one recipient
acceptable for the message to be sent. A boolean value.

[lst_item [option -originator]]

A string containing an 822-style address specification. If present the
header isn't examined for an originator address.

[lst_item [option -recipients]]

A string containing one or more 822-style address specifications. If
present the header isn't examined for recipient addresses). If the
string contains more than one address they will be separated by
commas.

[lst_item [option -header]]

A list of keywords and their values (may occur zero or more times).

[lst_item [option -usetls]]

This package supports the RFC 3207 TLS extension by default provided the 
tls package is available. You can turn this off with this boolean option.

[lst_item [option -tlspolicy]]

This option lets you specify a command to be called if an error occurs 
during TLS setup. The command is called with the SMTP code and diagnostic
message appended. The command should return 'secure' or 'insecure' where
insecure will cause the package to continue on the unencrypted channel.
Returning 'secure' will cause the socket to be closed and the next server
in the [option -servers] list to be tried.

[list_end]
[nl]

If the [option -originator] option is not present, the originator
address is taken from [const From] (or [const Resent-From]);
similarly, if the [option -recipients] option is not present,
recipient addresses are taken from [const To], [const cc], and
[const Bcc] (or [const Resent-To], and so on). Note that the header
key/values supplied by the [option -header] option (not those present
in the MIME part) are consulted. Regardless, header key/values are
added to the outgoing message as necessary to ensure that a valid
822-style message is sent.

[nl]

The command returns a list indicating which recipients were
unacceptable to the SMTP server. Each element of the list is another
list, containing the address, an SMTP error code, and a textual
diagnostic. Depending on the [option -atleastone] option and the
intended recipients, a non-empty list may still indicate that the
message was accepted by the server.

[list_end]

[section EXAMPLE]

[example {
proc send_simple_message {recipient email_server subject body} {
    package require smtp
    package require mime

    set token [mime::initialize -canonical text/plain \\
	-string $body]
    mime::setheader $token Subject $subject
    smtp::sendmessage $token \\
	-recipients $recipient -servers $email_server
    mime::finalize $token
}

send_simple_message someone@somewhere.com localhost \\
    "This is the subject." "This is the message."
}]

[see_also mime pop3 ftp http]
[keywords mail mail email smtp mime tls \
     {rfc 821} {rfc 822} {rfc 3207} internet net]
[manpage_end]
