/*
 * loop.c -- the main loop of the capture engine
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */

/* 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at you option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111,
 * USA.
 */

#include "tcpick.h"
#include "extern.h"

int 
got_packet (u_char * useless,
	    const struct pcap_pkthdr* hdr,
	    const u_char* packet) 
/* called by pcap_loop.
   this is the main loop for the packet engine. */

{ /* FIXME: this function is too long */
	if(! packet)
		fault( "got_packet", "didn't grab packet" );

	pcount++; /* packet counter */
        
	ippacket=(struct ip *)(packet + dl_size);
	switch(ippacket->ip_p) {
	case IPPROTO_TCP:

		tcppacket = (struct tcphdr *)(packet + dl_size + ip_size);
		payload = (u_char *)(packet + dl_size + ip_size + tcppacket->doff * 4); 
		payload_len = hdr->len - (int)( payload - packet );

		if( flags.header > 0 )
			display_header( stdout, ippacket, tcppacket, 
					payload_len );
		
		verify(); /* call the core to manage the packet */
		
		if( ! payload_len || SILENCE )
			return 0;

		out_flavour( flags.display_payload, 
			     stdout, payload, payload_len );
		
		break;
		
		
	default: /* non-TCP packet */
		debug( "non-TCP packet caught: %s > %s",
		       inet_ntoa(ippacket->ip_src),
		       inet_ntoa(ippacket->ip_dst) );
	}
}
