/*
 * tracker.c -- connection status handler
 * Part of the tcpick project
 *
 * Author: Francesco Stablum <duskdruid @ despammed.com>
 *
 * Copyright (C) 2003, 2004  Francesco Stablum
 * Licensed under the GPL
 *
 */

/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "tcpick.h"
#include "extern.h"

struct conn_t * first_conn = NULL; /*all connections, ends on a 0*/
struct conn_t * last_conn  = NULL; 
int conn_num; /* number of active connections */
int opened_num;

int 
status_switch(conn_t * prev, Status_t status) 
{
#define CURR (prev->next)
	display_status( stdout, CURR, status );
	if ( status == CLOSED )
		rmconn( prev );
	else
		CURR->status = status;
}

int 
newconn( conn_t * prev_ring )
/* allocates a new connection */
{
	conn_t * conn;

	if( flags.trackonly != -1 ) {
		if( flags.trackonly_first &&
		    ( conn_num >= flags.trackonly ) )
			return -1;
		else if( opened_num >= flags.trackonly )
			return -1;
		else
			opened_num++; /* FIXME: name sucks */
	}
	conn_num++;

	conn = ( conn_t * )S_calloc( sizeof( conn_t ), 1 );
	
	prev_ring->next = conn; /* and the chain becomes longer... :)
				   thank you mainman for this good idea! */
	last_conn = conn;

	conn->client.side = CLIENT;
	conn->server.side = SERVER;

	conn->client.ip.s_addr = ippacket->ip_src.s_addr;
	conn->server.ip.s_addr = ippacket->ip_dst.s_addr;
	conn->client.port      = tcppacket->source;
	conn->server.port      = tcppacket->dest;
	
	conn->client.sip  = ntohl(tcppacket->seq) + 1;
	
	conn->client.oth = & (conn->server);
	conn->server.oth = & (conn->client);
	
	conn->num = conn_num;
	
	status_switch( prev_ring, SYN_SENT );
}

int rmconn( conn_t * prev_ring )
/* removes from the linked-list and deallocates a connection
 * prev_ring 
 */
{
	conn_t * curr = prev_ring->next;

	prev_ring->next = curr->next;
	if(! curr->next )
		last_conn = prev_ring;
	
	free_desc( &(curr->client) );
	free_desc( &(curr->server) );
	
	curr = first_conn;
	
	if( flags.exitclosed ) {
		if( flags.exitclosed_first ) { /* -Ef */
			while( curr->num > flags.exitclosed ) {
				if(! (curr->next) )
					exit( EXIT_SUCCESS ); 
				curr = curr->next;
			}
		} else /* -E */
			if(! --flags.exitclosed )
				exit( EXIT_SUCCESS ); 
	}

	if( flags.trackonly &&
	    (! flags.trackonly_first) )
		opened_num--;
}

int free_desc( struct host_descriptor_t * desc )
/* frees the host descriptor and closes the file */
{
	struct fragment_t * tmp;

	if( desc->file ) {
		fclose( desc->file );
		S_free( desc->filename );
	}
	
	while( desc->unack ) { /* FIXME: desc->unack should be just NULL when closes! 
				* I should check it! */
		S_free( desc->unack->payload );
		tmp = desc->unack;
		desc->unack = desc->unack->next;
		S_free( tmp );
	}

}
