/*
 * mod_ip_ttl.c
 *
 * Copyright (c) 2001 Dug Song <dugsong@monkey.org>
 *
 * $Id: mod_ip_ttl.c 2000 2008-04-27 06:17:35Z aturner $
 */

#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "argv.h"
#include "mod.h"
#include "pkt.h"

struct ip_ttl_data {
	int	ttl;
};

void *
ip_ttl_close(void *d)
{
	if (d != NULL)
		free(d);
	return (NULL);
}

void *
ip_ttl_open(int argc, char *argv[])
{
	struct ip_ttl_data *data;

	if (argc != 2)
		return (NULL);

	if ((data = calloc(1, sizeof(*data))) == NULL)
		return (NULL);
	
	if ((data->ttl = atoi(argv[1])) <= 0 || data->ttl > 255)
		return (ip_ttl_close(data));

	return (data);
}

int
ip_ttl_apply(void *d, struct pktq *pktq)
{
	struct ip_ttl_data *data = (struct ip_ttl_data *)d;
	struct pkt *pkt;
	int ttldec;

	TAILQ_FOREACH(pkt, pktq, pkt_next) {
		ttldec = pkt->pkt_ip->ip_ttl - data->ttl;
		pkt->pkt_ip->ip_ttl = data->ttl;
		
		if (pkt->pkt_ip->ip_sum >= htons(0xffff - (ttldec << 8)))
			pkt->pkt_ip->ip_sum += htons(ttldec << 8) + 1;
		else
			pkt->pkt_ip->ip_sum += htons(ttldec << 8);
	}
	return (0);
}

struct mod mod_ip_ttl = {
	"ip_ttl",			/* name */
	"ip_ttl <ttl>",			/* usage */
	ip_ttl_open,			/* open */
	ip_ttl_apply,			/* apply */
	ip_ttl_close			/* close */
};
