/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file. - thanx :)

//roxton
28.11.2003, n.p. Nirvana "You Know You're Right" 
and this project is starting
 */

/***************************************************************************
                          main.c  -  description
                             -------------------
    begin                : Nov 28 2003
    copyright            : (C) 2003, 2004, 2005 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <sys/stat.h>
#include <time.h>
#include <stdio.h>
#include <signal.h>

#include "callbacks.h"
#include "tea_config.h"
#include "tea_defs.h"

//#include "mysocket.h"


void sig_handler (int i)
{
  switch (i)
         {
          case SIGTERM: 
          case SIGHUP:  
          case SIGABRT:
          case SIGINT:
                      if (confile.do_save_all_on_termination) 
                         doc_save_all ();         

                      if (confile.do_crash_file)
                         doc_save_emergency ();

                      ui_done();
                      gtk_main_quit ();
                      exit (i);
         }
}


int main (int argc, char *argv[])
{
  GtkWidget *app_main_window;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif
  gtk_set_locale ();

  gchar *grc = get_tea_config_file ("gtkrc");
  if (g_file_test (grc, G_FILE_TEST_EXISTS))
     gtk_rc_add_default_file (grc);
  g_free (grc);

  gtk_init (&argc, &argv);
  
  signal (SIGHUP, sig_handler);
  signal (SIGABRT, sig_handler);
  signal (SIGTERM, sig_handler);
  signal (SIGINT, sig_handler);

#ifdef CHAI_MODE
  
  hl_init ();

#endif

  tea_start ();
    
  app_main_window = create_tea_main_window ();
  
  gtk_widget_show (app_main_window);

  g_argv = argv;
  g_argc = argc;

  gtk_init_add (tea_init, NULL);
  gtk_rc_add_default_file (confile.file_gtkrc);

  //mysockets_init (confile.io_channel);  

  update_enc_menu ();
  reload_ext_programs ();
  bmx_reload ();
  create_tags ();
  prepare_hl_all ();
  reload_snippets ();   
  reload_dicts ();
  reload_sessions ();
  reload_templates ();
  reload_autosave ();
  reload_hotkeys ();
  reload_autoreplace ();
  update_recent_list_menu (TRUE);

  gtk_main ();
  tea_done ();
  //mysockets_done ();

  return 0;
}
