/***************************************************************************
                          tea_gtk_utils.c  -  description
                             -------------------
    begin                : aug. 2004
    copyright            : (C) 2004-2006 by Peter 'Roxton' Semiletov
    email                : peter.semiletov@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENCHANT_SUPPORTED
#include "enchant.h"
#endif

#include <glib.h>

#ifdef HAVE_LIBASPELL

#include "aspell.h"

GList* get_speller_modules_list (const gchar *default_lang)
{
  gchar *lang;
  if (! default_lang)
     lang = g_strdup ("C");
  else
      lang = g_strdup (default_lang);

  GList *l = NULL;
  AspellDictInfoList *dlist;
  AspellDictInfoEnumeration *dels;
  const AspellDictInfo *entry;
  AspellConfig *config;

  config = new_aspell_config ();
  aspell_config_replace (config, "lang", lang);
  aspell_config_replace (config, "encoding", "UTF-8");

  dlist = get_aspell_dict_info_list (config);

  delete_aspell_config(config);

  dels = aspell_dict_info_list_elements(dlist);

  while ((entry = aspell_dict_info_enumeration_next (dels)) != 0)
        if (entry)
           l = g_list_prepend (l, g_strdup (entry->name));

  delete_aspell_dict_info_enumeration(dels);
  g_free (lang);

  return l;
}


GList* get_suggestions_list (const gchar *lang, const gchar *s)
{
  GList *result = NULL;

  AspellConfig *spell_config = new_aspell_config ();

  AspellCanHaveError *ret;
  AspellSpeller *speller;

  aspell_config_replace (spell_config, "lang", lang);
  aspell_config_replace (spell_config, "encoding", "UTF-8");

  ret = new_aspell_speller (spell_config);

  if (aspell_error (ret) != 0)
     {
      g_print ("Error: %s\n", aspell_error_message (ret));
      delete_aspell_config (spell_config);
      delete_aspell_can_have_error (ret);
      return NULL;
     }

  speller = to_aspell_speller (ret);
  AspellWordList *suggestions = aspell_speller_suggest (speller, s, -1);

  if (! suggestions)
     {
      delete_aspell_speller (speller);
      return NULL;
     }

  AspellStringEnumeration *elements = aspell_word_list_elements (suggestions);
  const char *word;

  while (word = aspell_string_enumeration_next (elements))
        result = g_list_prepend (result, g_strdup (word));

  delete_aspell_string_enumeration (elements);

  delete_aspell_speller (speller);
  delete_aspell_config (spell_config);

  return g_list_reverse (result);
}

#endif

#ifdef ENCHANT_SUPPORTED

static EnchantBroker *broker;
static EnchantDict *dict;

gboolean enchant_check (const gchar *word)
{
  if (! word)
    return FALSE;

   return enchant_dict_check (dict, word, -1);
}


void enchant_init (void)
{
  broker = NULL;
  dict = NULL;

  broker = enchant_broker_init ();
  if (! broker)
     return;

  dict = enchant_broker_request_dict (broker, g_getenv ("LANG"));
}


void enchant_done (void)
{
  if (dict)
     enchant_broker_free_dict (broker, dict);
  if (broker)
     enchant_broker_free (broker);
}


GList* enchant_get_suggestions_list (const gchar *s)
{
  GList *result = NULL;
  size_t out_n_suggs;

  gchar **a = enchant_dict_suggest (dict, s, -1, &out_n_suggs);
  result = arr_to_glist (a);
  enchant_dict_free_string_list (dict, a);

  return result;
}

#endif
