-- ================================================================================
--   ingres SQL DDL Script File
-- ================================================================================


-- ================================================================================
-- 
--   Generated by:      tedia2sql -- v1.2.9
--                      See http://tedia2sql.tigris.org/AUTHORS.html for tedia2sql author information
-- 
--   Target Database:   ingres
--   Generated at:      Tue Aug 12 11:43:59 2003
--   Input File:        TestERD.dia
-- 
-- ================================================================================



-- Generated SQL Constraints Drop statements
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

-- drop index idx_iimd5 for ingres
-- drop index idx_iiid for ingres
-- drop index idx_siiid for ingres
-- drop index idx_siips for ingres
-- drop index idx_iclidnm for ingres
-- drop index idx_uinm for ingres
-- drop index idx_uiid for ingres
-- drop index idx_uauiid for ingres
-- drop index idx_uiruid for ingres
-- drop index idx_acid for ingres
-- drop index idx_usmd5 for ingres
-- alter table subImageInfo drop constraint fk_iisii --(is implicitly done)
-- alter table imageCategoryList drop constraint fk_iiicl --(is implicitly done)
-- alter table imageAttribute drop constraint fk_iiia --(is implicitly done)
-- alter table userImageRating drop constraint fk_uiuir --(is implicitly done)
-- alter table userAttribute drop constraint fk_uiua --(is implicitly done)
-- alter table userSession drop constraint fk_uius --(is implicitly done)
-- alter table imageAttribute drop constraint fk_iaac --(is implicitly done)
-- alter table userAttribute drop constraint fk_acua --(is implicitly done)


-- Generated Permissions Drops
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

-- revoke all on imageInfo from fmorg for ingres
-- revoke select on imageInfo from public for ingres
-- revoke all on subImageInfo from fmorg for ingres
-- revoke all on imageCategoryList from fmorg for ingres
-- revoke select on categoryNames from public for ingres
-- revoke all on categoryNames from fmorg for ingres
-- revoke all on imageAttribute from fmorg for ingres
-- revoke all on userInfo from fmorg for ingres
-- revoke all on userAttribute from fmorg for ingres
-- revoke all on userImageRating from fmorg for ingres
-- revoke all on attributeCategory from fmorg for ingres
-- revoke all on userSession from fmorg for ingres
-- revoke select on extremes from public for ingres
-- revoke all on extremes from fmorg for ingres



-- Generated SQL View Drop Statements
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

drop view ratings_view 
\g
drop view whorated_view 
\g
drop view users_view 
\g


-- Generated SQL Schema Drop statements
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

drop table imageInfo 
\g
drop table subImageInfo 
\g
drop table imageCategoryList 
\g
drop table categoryNames 
\g
drop table imageAttribute 
\g
drop table userInfo 
\g
drop table userAttribute 
\g
drop table userImageRating 
\g
drop table attributeCategory 
\g
drop table userSession 
\g
drop table extremes 
\g


-- Generated SQL Schema
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia


-- imageInfo
create table imageInfo (
  id                        numeric (18) not null,
  insertionDate             date default now() not null,
  md5sum                    char (32) not null,
  binaryType                varchar (16) default 'jpg' null,
  name                      varchar (64) not null,
  locationList              varchar (128) default '//imgserver.org',
  description               varchar (128) null,
  constraint pk_imageInfo primary key (id)
) 
\g

-- subImageInfo
create table subImageInfo (
  imageInfo_id              numeric (18) not null,
  pixSize                   integer not null,
  constraint pk_subImageInfo primary key (imageInfo_id,pixSize)
) 
\g

-- imageCategoryList
create table imageCategoryList (
  imageInfo_id              numeric (18) not null,
  name                      varchar (32) not null,
  constraint pk_imageCategoryList primary key (imageInfo_id,name)
) 
\g

-- categoryNames
create table categoryNames (
  name                      varchar (32) not null,
  constraint pk_categoryNames primary key (name)
) 
\g

-- imageAttribute
create table imageAttribute (
  imageInfo_id              numeric (18) not null,
  attributeCategory_id      numeric (18) not null,
  numValue                  numeric (8),
  category                  numeric (4),
  constraint pk_imageAttribute primary key (imageInfo_id,attributeCategory_id)
) 
\g

-- userInfo
create table userInfo (
  id                        numeric (18) not null,
  insertionDate             date,
  md5sum                    char (32),
  birthDate                 date,
  gender                    char (1),
  name                      varchar (32),
  email                     varchar (96),
  currentCategory           varchar (32),
  lastDebitDate             date,
  acctBalance               numeric (10,2),
  active                    integer,
  constraint pk_userInfo primary key (id)
) 
\g

-- userAttribute
create table userAttribute (
  userInfo_id               numeric (18) not null,
  attributeCategory_id      numeric (18) not null,
  numValue                  numeric (5,4),
  constraint pk_userAttribute primary key (userInfo_id,attributeCategory_id)
) 
\g

-- userImageRating
create table userImageRating (
  userInfo_id               numeric (18) not null,
  imageInfo_id              numeric (15) not null,
  rating                    integer,
  constraint pk_userImageRating primary key (userInfo_id,imageInfo_id)
) 
\g

-- attributeCategory
create table attributeCategory (
  id                        numeric (18) not null,
  attributeDesc             varchar (128),
  constraint pk_attributeCategory primary key (id)
) 
\g

-- userSession
create table userSession (
  userInfo_id               numeric (18) not null,
  md5sum                    char (32) not null,
  insertionDate             date,
  expireDate                date,
  ipAddress                 varchar (24),
  constraint pk_userSession primary key (userInfo_id,md5sum)
) 
\g

-- extremes
create table extremes (
  name                      varchar (32) not null,
  colName                   varchar (64),
  minVal                    numeric (15),
  maxVal                    numeric (15),
  constraint pk_extremes primary key (name)
) 
\g


-- Generated SQL Views
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia


-- ratings_view
create view ratings_view as
  select b.name, c.md5sum, a.rating
  from userImageRating a,
    userImageRating z,
    userInfo b,
    imageInfo c
  where (((a.userInfo_id = b.id)
    and (a.imageInfo_id = c.id)
    and (a.userInfo_id = z.userInfo_id))
    and (a.userInfo_id <> z.userInfo_id))
  order by c.md5sum,b.name,a.rating

\g

-- whorated_view
create view whorated_view as
  select a.name, count (*) as numRatings
  from userInfo a,
    userImageRating b
  where (a.id = b.userInfo_id)
  group by a.name

\g

-- users_view
create view users_view as
  select id, birthDate, name ||'<'|| email ||'>' as whoIsThis, currentCategory, acctBalance, active
  from userInfo
  order by userInfo.name

\g



-- Generated Permissions
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

-- grant all on imageInfo to fmorg for ingres
-- grant select on imageInfo to public for ingres
-- grant all on subImageInfo to fmorg for ingres
-- grant all on imageCategoryList to fmorg for ingres
-- grant select on categoryNames to public for ingres
-- grant all on categoryNames to fmorg for ingres
-- grant all on imageAttribute to fmorg for ingres
-- grant all on userInfo to fmorg for ingres
-- grant all on userAttribute to fmorg for ingres
-- grant all on userImageRating to fmorg for ingres
-- grant all on attributeCategory to fmorg for ingres
-- grant all on userSession to fmorg for ingres
-- grant select on extremes to public for ingres
-- grant all on extremes to fmorg for ingres


-- Generated SQL Insert statements
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia


-- inserts for categoryNames
-- insert into categoryNames values ( 'Buildings' ) -- for ingres
-- insert into categoryNames values ( 'Landscapes' ) -- for ingres
-- insert into categoryNames values ( 'Nudes' ) -- for ingres
-- insert into categoryNames values ( 'Life Studies' ) -- for ingres
-- insert into categoryNames values ( 'Portraits' ) -- for ingres
-- insert into categoryNames values ( 'Abstracts' ) -- for ingres

-- inserts for attributeCategory
-- insert into attributeCategory values ( 1,'Blurriness' ) -- for ingres
-- insert into attributeCategory values ( 2,'Contrastiness' ) -- for ingres
-- insert into attributeCategory values ( 3,'Saturation' ) -- for ingres
-- insert into attributeCategory values ( 4,'Size' ) -- for ingres
-- insert into attributeCategory values ( 5,'Relevence' ) -- for ingres


-- Generated SQL Constraints
-- --------------------------------------------------------------------
--     Target Database:   ingres
--     SQL Generator:     tedia2sql -- v1.2.9
--     Generated at:      Tue Aug 12 11:43:58 2003
--     Input File:        TestERD.dia

-- create unique index idx_iimd5 on imageInfo (md5sum) for ingres
-- create index idx_iiid on imageInfo (id) for ingres
-- create index idx_siiid on subImageInfo (imageInfo_id) for ingres
-- create index idx_siips on subImageInfo (pixSize) for ingres
-- create index idx_iclidnm on imageCategoryList (imageInfo_id,name) for ingres
-- create unique index idx_uinm on userInfo (name,md5sum) for ingres
-- create index idx_uiid on userInfo (id) for ingres
-- create index idx_uauiid on userAttribute (userInfo_id) for ingres
-- create index idx_uiruid on userImageRating (userInfo_id) for ingres
-- create index idx_acid on attributeCategory (id) for ingres
-- create index idx_usmd5 on userSession (md5sum) for ingres
-- alter table subImageInfo add constraint fk_iisii foreign key (imageInfo_id) references imageInfo (id) for ingres
-- alter table imageCategoryList add constraint fk_iiicl foreign key (imageinfo_id) references imageInfo (id) for ingres
-- alter table imageAttribute add constraint fk_iiia foreign key (imageInfo_id) references imageInfo (id) for ingres
-- alter table userImageRating add constraint fk_uiuir foreign key (userInfo_id) references userInfo (id) for ingres
-- alter table userAttribute add constraint fk_uiua foreign key (userInfo_id) references userInfo (id) for ingres
-- alter table userSession add constraint fk_uius foreign key (userInfo_id) references userInfo (id) for ingres
-- alter table imageAttribute add constraint fk_iaac foreign key (attributeCategory_id) references attributeCategory (id) for ingres
-- alter table userAttribute add constraint fk_acua foreign key (attributeCategory_id) references attributeCategory (id) for ingres

-- ingres requires a special 'quit' command
\q

