package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateImagePipeline invokes the ecs.CreateImagePipeline API synchronously
func (client *Client) CreateImagePipeline(request *CreateImagePipelineRequest) (response *CreateImagePipelineResponse, err error) {
	response = CreateCreateImagePipelineResponse()
	err = client.DoAction(request, response)
	return
}

// CreateImagePipelineWithChan invokes the ecs.CreateImagePipeline API asynchronously
func (client *Client) CreateImagePipelineWithChan(request *CreateImagePipelineRequest) (<-chan *CreateImagePipelineResponse, <-chan error) {
	responseChan := make(chan *CreateImagePipelineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateImagePipeline(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateImagePipelineWithCallback invokes the ecs.CreateImagePipeline API asynchronously
func (client *Client) CreateImagePipelineWithCallback(request *CreateImagePipelineRequest, callback func(response *CreateImagePipelineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateImagePipelineResponse
		var err error
		defer close(result)
		response, err = client.CreateImagePipeline(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateImagePipelineRequest is the request struct for api CreateImagePipeline
type CreateImagePipelineRequest struct {
	*requests.RpcRequest
	BaseImageType           string                    `position:"Query" name:"BaseImageType"`
	ResourceOwnerId         requests.Integer          `position:"Query" name:"ResourceOwnerId"`
	ClientToken             string                    `position:"Query" name:"ClientToken"`
	ToRegionId              *[]string                 `position:"Query" name:"ToRegionId"  type:"Repeated"`
	InternetMaxBandwidthOut requests.Integer          `position:"Query" name:"InternetMaxBandwidthOut"`
	Description             string                    `position:"Query" name:"Description"`
	ResourceGroupId         string                    `position:"Query" name:"ResourceGroupId"`
	ImageName               string                    `position:"Query" name:"ImageName"`
	SystemDiskSize          requests.Integer          `position:"Query" name:"SystemDiskSize"`
	InstanceType            string                    `position:"Query" name:"InstanceType"`
	Tag                     *[]CreateImagePipelineTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount    string                    `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount            string                    `position:"Query" name:"OwnerAccount"`
	OwnerId                 requests.Integer          `position:"Query" name:"OwnerId"`
	BaseImage               string                    `position:"Query" name:"BaseImage"`
	VSwitchId               string                    `position:"Query" name:"VSwitchId"`
	AddAccount              *[]string                 `position:"Query" name:"AddAccount"  type:"Repeated"`
	DeleteInstanceOnFailure requests.Boolean          `position:"Query" name:"DeleteInstanceOnFailure"`
	Name                    string                    `position:"Query" name:"Name"`
	BuildContent            string                    `position:"Query" name:"BuildContent"`
}

// CreateImagePipelineTag is a repeated param struct in CreateImagePipelineRequest
type CreateImagePipelineTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// CreateImagePipelineResponse is the response struct for api CreateImagePipeline
type CreateImagePipelineResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ImagePipelineId string `json:"ImagePipelineId" xml:"ImagePipelineId"`
}

// CreateCreateImagePipelineRequest creates a request to invoke CreateImagePipeline API
func CreateCreateImagePipelineRequest() (request *CreateImagePipelineRequest) {
	request = &CreateImagePipelineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "CreateImagePipeline", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateImagePipelineResponse creates a response to parse from CreateImagePipeline response
func CreateCreateImagePipelineResponse() (response *CreateImagePipelineResponse) {
	response = &CreateImagePipelineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
