# telepathy-butterfly - an MSN connection manager for Telepathy
#
# Copyright (C) 2006 Ali Sabil <ali.sabil@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import telepathy

import pymsn

class MsnSubscribeListChannel(telepathy.server.ChannelTypeContactList,
        telepathy.server.ChannelInterfaceGroup):

    def __init__(self, conn, handle):
        telepathy.server.ChannelTypeContactList.__init__(self, conn, handle)
        telepathy.server.ChannelInterfaceGroup.__init__(self)
        self.GroupFlagsChanged(telepathy.CHANNEL_GROUP_FLAG_CAN_ADD | \
                telepathy.CHANNEL_GROUP_FLAG_CAN_REMOVE | \
                telepathy.CHANNEL_GROUP_FLAG_CAN_RESCIND, 0)

    def contact_added(self, handle, contact):
        forward = contact.in_list(pymsn.List.FORWARD)
        pending = contact.in_list(pymsn.List.PENDING)
        reverse = contact.in_list(pymsn.List.REVERSE)
        
        added = set()
        local_pending = set()
        remote_pending = set()

        if forward:
            added.add(handle)
        elif pending:
            local_pending.add(handle)
        elif forward and not reverse:
            remote_pending.add(handle)

        if added or local_pending or remote_pending:
            self.MembersChanged('', added, (), local_pending, remote_pending, 0,
                                telepathy.CHANNEL_GROUP_CHANGE_REASON_NONE)

    def AddMembers(self, members, message):
        self._conn.check_connected()

        handles = []
        for id in members:
            self._conn.check_handle(telepathy.CONNECTION_HANDLE_TYPE_CONTACT, id)
            handles.append(self._conn._handles[telepathy.CONNECTION_HANDLE_TYPE_CONTACT, id])

        for handle in handles:
            if handle in self._remote_pending:
                raise PermissionDenied('you may not approve remote pending members')
            elif handle in self._members:
                pass
            elif handle in self._local_pending:
                contact = self._conn.get_contact_by_passport(handle.get_name())
                contact.accept()
            else:
                contact = self._conn.get_contact_by_passport(handle.get_name())
                contact.add()

    def RemoveMembers(self, members, message):
        self._conn.check_connected()

        handles = []
        for id in members:
            self._conn.check_handle(telepathy.CONNECTION_HANDLE_TYPE_CONTACT, id)
            handles.append(self._conn._handles[telepathy.CONNECTION_HANDLE_TYPE_CONTACT, id])

        for handle in handles:
            if handle in self._members:
                contact = self._conn.get_contact_by_passport(handle.get_name())
                contact.remove()
            elif handle in self._local_pending:
                contact = self._conn.get_contact_by_passport(handle.get_name())
                contact.reject()
