/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-dlg-about.h:
 * Classical About Dialog
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_ABOUT_H__
#define __TI_DLG_ABOUT_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgAbout TIDlgAbout;
typedef struct _TIDlgAboutClass TIDlgAboutClass;

#define TI_TYPE_DLG_ABOUT               ti_dlg_about_get_type()
#define TI_DLG_ABOUT(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_ABOUT, TIDlgAbout))
#define TI_DLG_ABOUT_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_ABOUT, TIDlgAboutClass))
#define TI_IS_DLG_ABOUT(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_ABOUT))
#define TI_IS_DLG_ABOUT_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_ABOUT))
#define TI_DLG_ABOUT_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_ABOUT, TIDlgAboutClass))

struct _TIDlgAbout
{
    GObject parent;
};

struct _TIDlgAboutClass
{
    GObjectClass parent;
};

GType ti_dlg_about_get_type (void);

TIDlgAbout* ti_dlg_about_new (GtkWindow* parent);

/**
 * Shows the Preferences dialog.
 * It also updates the global preferences accordingly.
 */
void ti_dlg_about_run (TIDlgAbout* dlg_about);

#endif
