/*
 * Telapathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 * 
 * ti-wnd-main.h:
 * Main Window - Main application window.
 * 
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WND_MAIN_H__
#define __TI_WND_MAIN_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include "ti-channel.h"

/*
 * Type macros.
 */

typedef struct _TIWndMain TIWndMain;
typedef struct _TIWndMainClass TIWndMainClass;

#define TI_TYPE_WND_MAIN               ti_wnd_main_get_type()
#define TI_WND_MAIN(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_WND_MAIN, TIWndMain))
#define TI_WND_MAIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_WND_MAIN, TIWndMainClass))
#define TI_IS_WND_MAIN(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_WND_MAIN))
#define TI_IS_WND_MAIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_WND_MAIN))
#define TI_WND_MAIN_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_WND_MAIN, TIWndMainClass))

struct _TIWndMain {
    GObject parent;
};

GType ti_wnd_main_get_type (void);

TIWndMain* ti_wnd_main_new ();

/**
 * Show
 * Shows the channel window.
 */
void ti_wnd_main_show (TIWndMain* wnd_main);

#endif
