/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-user-status.h:
 * Dialog for AddStatus() and RemoveStatus() methods on
 * [...].Telepathy.Connection.Interface.Presence interface.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_USER_STATUS_H__
#define __TI_DLG_USER_STATUS_H__

#include <gtk/gtk.h>

/*
 * Type macros.
 */

typedef struct _TIDlgUserStatus TIDlgUserStatus;
typedef struct _TIDlgUserStatusClass TIDlgUserStatusClass;

#define TI_TYPE_DLG_USER_STATUS               ti_dlg_user_status_get_type()
#define TI_DLG_USER_STATUS(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_USER_STATUS, TIDlgUserStatus))
#define TI_DLG_USER_STATUS_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_USER_STATUS, TIDlgUserStatusClass))
#define TI_IS_DLG_USER_STATUS(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_USER_STATUS))
#define TI_IS_DLG_USER_STATUS_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_USER_STATUS))
#define TI_DLG_USER_STATUS_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_USER_STATUS, TIDlgUserStatusClass))

struct _TIDlgUserStatus
{
    GObject parent;
};

struct _TIDlgUserStatusClass
{
    GObjectClass parent;
};

GType ti_dlg_user_status_get_type (void);

TIDlgUserStatus *ti_dlg_user_status_new (GtkWindow *parent, GtkTreeModel *tree_model, guint column);

/**
 * Shows the "Add Status" dialog.
 *
 * @param status Chosen status. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_user_status_run_add (TIDlgUserStatus *dlg_user_status, gchar **status);

/**
 * Shows the "Remove Status" dialog.
 *
 * @param status Chosen status. Must be freed after use.
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_user_status_run_remove (TIDlgUserStatus *dlg_user_status, gchar **status);

#endif
