/*
 * Hold page for channel notebook.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_PAGE_HOLD_H__
#define __TI_PAGE_HOLD_H__

#include <gtk/gtk.h>
#include <glib-object.h>
#include <telepathy-glib/channel.h>

#include "page.h"

typedef struct _TIPageHold TIPageHold;
typedef struct _TIPageHoldClass TIPageHoldClass;
typedef struct _TIPageHoldPrivate TIPageHoldPrivate;

GType ti_page_hold_get_type (void);

#define TI_TYPE_PAGE_HOLD \
  (ti_page_hold_get_type ())
#define TI_PAGE_HOLD(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), TI_TYPE_PAGE_HOLD, \
                               TIPageHold))
#define TI_PAGE_HOLD_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_PAGE_HOLD, \
                            TIPageHoldClass))
#define TI_IS_PAGE_HOLD(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TI_TYPE_PAGE_HOLD))
#define TI_IS_PAGE_HOLD_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_PAGE_HOLD))
#define TI_PAGE_HOLD_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), TI_TYPE_PAGE_HOLD, \
                              TIPageHoldClass))

struct _TIPageHold {
    TIPage parent;
    TIPageHoldPrivate *priv;
};

TIPageHold *ti_page_hold_new (GtkNotebook *parent_notebook,
    TpChannel *channel);

#endif
