/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-constants.h:
 * All relevant constants used in Telepathy Inspector.
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_CONSTANTS_H__
#define __TI_CONSTANTS_H__

#include <glib.h>

G_BEGIN_DECLS

/* Preferences: Handle Display Mode - How to display contact handles */
/* Show handle numbers directly */
#define TI_PREFERENCES_HANDLE_DISPLAY_HANDLE 0
/* Show their names, when available */
#define TI_PREFERENCES_HANDLE_DISPLAY_NAME   1

/* Column definitions for a GtkListStore containing Telepathy handles. */
enum {
    /* uint */
    TI_HANDLES_LIST_COLUMN_TYPE = 0,
    /* uint */
    TI_HANDLES_LIST_COLUMN_NUMBER,
    /* string */
    TI_HANDLES_LIST_COLUMN_NAME,
    /* boolean, TRUE if the name was given by the conn. man. (a real name)
     * and FALSE if it was locally generated. */
    TI_HANDLES_LIST_COLUMN_IS_REAL_NAME,
    TI_HANDLES_LIST_N_COLUMNS,
};

G_END_DECLS
#endif /* __TI_CONSTANTS_H__ */
