/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-request-channel.h:
 * DlgRequestChannel - Request Channel Dialog
 *
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Author - Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_DLG_REQUEST_CHANNEL_H__
#define __TI_DLG_REQUEST_CHANNEL_H__

#include <gtk/gtk.h>

#include "handle-mapper.h"

/*
 * Type macros.
 */

typedef struct _TIDlgRequestChannel TIDlgRequestChannel;
typedef struct _TIDlgRequestChannelClass TIDlgRequestChannelClass;

#define TI_TYPE_DLG_REQUEST_CHANNEL               ti_dlg_request_channel_get_type()
#define TI_DLG_REQUEST_CHANNEL(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_DLG_REQUEST_CHANNEL, TIDlgRequestChannel))
#define TI_DLG_REQUEST_CHANNEL_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_DLG_REQUEST_CHANNEL, TIDlgRequestChannelClass))
#define TI_IS_DLG_REQUEST_CHANNEL(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_DLG_REQUEST_CHANNEL))
#define TI_IS_DLG_REQUEST_CHANNEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_DLG_REQUEST_CHANNEL))
#define TI_DLG_REQUEST_CHANNEL_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_DLG_REQUEST_CHANNEL, TIDlgRequestChannelClass))

struct _TIDlgRequestChannel
{
    GObject parent;
};

struct _TIDlgRequestChannelClass
{
    GObjectClass parent;
};

GType ti_dlg_request_channel_get_type (void);

TIDlgRequestChannel *ti_dlg_request_channel_new (GtkWindow *parent, TIHandleMapper *handle_mapper);

/**
 * Shows the Request Channel dialog.
 *
 * @return TRUE if the user clicked "OK" and FALSE otherwise.
 */
gboolean ti_dlg_request_channel_run (TIDlgRequestChannel *dlg_request_channel,
                                     gchar **type, guint *handle_type, guint *handle, gboolean *suppress_handler);

#endif /* __TI_DLG_REQUEST_CHANNEL_H__ */
