/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-wnd-connection.h:
 * Connection Window - UI to expose org.freedesktop.Telepathy.Connection functionality
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __TI_WND_CONNECTION_H__
#define __TI_WND_CONNECTION_H__

#include <gtk/gtk.h>
#include <glib-object.h>

#include <telepathy-glib/connection.h>

/*
 * Type macros.
 */

typedef struct _TIWndConnection TIWndConnection;
typedef struct _TIWndConnectionClass TIWndConnectionClass;
typedef struct _TIWndConnectionPrivate TIWndConnectionPrivate;

#define TI_TYPE_WND_CONNECTION               ti_wnd_connection_get_type()
#define TI_WND_CONNECTION(object)            (G_TYPE_CHECK_INSTANCE_CAST ((object), TI_TYPE_WND_CONNECTION, TIWndConnection))
#define TI_WND_CONNECTION_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), TI_TYPE_WND_CONNECTION, TIWndConnectionClass))
#define TI_IS_WND_CONNECTION(object)         (G_TYPE_CHECK_INSTANCE_TYPE ((object), TI_TYPE_WND_CONNECTION))
#define TI_IS_WND_CONNECTION_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), TI_TYPE_WND_CONNECTION))
#define TI_WND_CONNECTION_GET_CLASS(object)  (G_TYPE_INSTANCE_GET_CLASS ((object), TI_TYPE_WND_CONNECTION, TIWndConnectionClass))

struct _TIWndConnection {
  GObject parent;
  TIWndConnectionPrivate *priv;
};

struct _TIWndConnectionClass {
  GObjectClass parent;
  /* class members */
  guint close_signal_id;
};

GType ti_wnd_connection_get_type (void);

TIWndConnection *ti_wnd_connection_new (GtkWindow *parent,
    TpConnection *connection);

/**
 * Show
 * Shows the connection window.
 */
void ti_wnd_connection_show (TIWndConnection *wnd_connection);

#endif
