#include <stdio.h>
#include <stdlib.h>

char *usage = "new [options] filename [template]\n\n"
"filename\n"
"	Filename of the file to create\n\n"
"-h, --help \n"
"	Print a list of options\n\n"
"-f, --force \n"
"	Overwrite any existing files\n\n"
"-l, --list \n"
"	List templates available for a given filename\n\n"
"-m, --mapping path\n"
"	Use the file at path to provide additional key/value mappings\n\n"
"-g, --global \n"
"	Use global templates instead of personal ones\n\n"
"-t, --template path\n"
"	Use the file at path as template\n\n"
"-s, --set FOO=bar\n"
"	Set the key FOO to the value bar\n\n"
"-y, --type type\n"
"	Set the file's type and do not try to extract it from the filename\n\n"
"-p, --permissions octal\n"
"	Set the new file's permissions\n\n"
"template\n"
"	Name of the template to use within global or local template directory\n\n"
;

/* ============================ print_usage () ============================== */
void print_usage(const int exitcode, const char *error, const char *more)
{
    fprintf(stderr, "%s\n", usage);
    if (error)
        fprintf(stderr, "%s: %s.\n\n", error, more);
    exit(exitcode);
}
