require 'div/tofusession'
require 'controller'
require 'model'

class YourTofuSession < Div::TofuSession
  def initialize(bartender, hint=nil)
    super(bartender, hint)
    Controller.set_template 'view.html'
    Controller.set_template 'view.ja.html', 'ja', Tempura::CharConvEUC
    Controller.set_model_factory Model
    @base = Controller.new(self)
  end

  def do_GET(context)
    update_div(context)
    content_type = "text/html"
    content_type << "; charset=euc-jp" if @base.lang == 'ja'
    context.res_header( 'content-type', content_type )
    context.res_body(@base.to_html(context))
  end
end

if $0 == __FILE__ then
  require 'tofu/tofulet'
  logger = WEBrick::Log::new($stderr, WEBrick::Log::DEBUG)
  httpd = WEBrick::HTTPServer.new(:Port => 2000,
                                   :AddressFamily => Socket::AF_INET,
                                   :BindAddress => '127.0.0.1',
                                   :Logger => logger)

  bartender = Tofu::Bartender.new(YourTofuSession)
  httpd.mount("/div", WEBrick::Tofulet, bartender)
  trap("INT"){ httpd.shutdown }
  httpd.start
end
