/*
    		 Crown Copyright (c) 1997
    
    This TenDRA(r) Computer Program is subject to Copyright
    owned by the United Kingdom Secretary of State for Defence
    acting through the Defence Evaluation and Research Agency
    (DERA).  It is made available to Recipients with a
    royalty-free licence for its use, reproduction, transfer
    to other parties and amendment for any purpose not excluding
    product development provided that any such use et cetera
    shall be deemed to be acceptance of the following conditions:-
    
        (1) Its Recipients shall ensure that this Notice is
        reproduced upon any copies or amended versions of it;
    
        (2) Any amended version of it shall be clearly marked to
        show both the nature of and the organisation responsible
        for the relevant amendment or amendments;
    
        (3) Its onward transfer from a recipient to another
        party shall be deemed to be that party's acceptance of
        these conditions;
    
        (4) DERA gives no warranty or assurance as to its
        quality or suitability for any purpose and DERA accepts
        no liability whatsoever in relation to any use to which
        it may be put.
*/


/*** action.c --- Action ADT.
 *
 ** Author: Steve Folkes <smf@hermes.mod.uk>
 *
 *** Commentary:
 *
 * This file implements the action manipulation routines.
 *
 *** Change Log:
 * $Log: action.c,v $
 * Revision 1.1.1.1  1998/01/17  15:57:46  release
 * First version to be checked into rolling release.
 *
 * Revision 1.2  1994/12/15  09:57:54  smf
 * Brought into line with OSSG C Coding Standards Document, as per
 * "CR94_178.sid+tld-update".
 *
 * Revision 1.1.1.1  1994/07/25  16:04:29  smf
 * Initial import of SID 1.8 non shared files.
 *
**/

/****************************************************************************/

#include "action.h"
#include "basic.h"
#include "name.h"
#include "rule.h"
#include "type.h"

/*--------------------------------------------------------------------------*/

ActionP
action_create PROTO_Z ()
{
    ActionP action = ALLOCATE (ActionT);

    types_init (action_param (action));
    types_init (action_result (action));
    action->code = NIL (GenericP);
    return (action);
}

#ifdef FS_FAST
#undef action_param
#endif /* defined (FS_FAST) */
TypeTupleP
action_param PROTO_N ((action))
	     PROTO_T (ActionP action)
{
    return (&(action->param));
}
#ifdef FS_FAST
#define action_param(a) (&((a)->param))
#endif /* defined (FS_FAST) */

#ifdef FS_FAST
#undef action_result
#endif /* defined (FS_FAST) */
TypeTupleP
action_result PROTO_N ((action))
	      PROTO_T (ActionP action)
{
    return (&(action->result));
}
#ifdef FS_FAST
#define action_result(a) (&((a)->result))
#endif /* defined (FS_FAST) */

#ifdef FS_FAST
#undef action_get_code
#endif /* defined (FS_FAST) */
GenericP
action_get_code PROTO_N ((action))
		PROTO_T (ActionP action)
{
    return (action->code);
}
#ifdef FS_FAST
#define action_get_code(a) ((a)->code)
#endif /* defined (FS_FAST) */

#ifdef FS_FAST
#undef action_set_code
#endif /* defined (FS_FAST) */
void
action_set_code PROTO_N ((action, code))
		PROTO_T (ActionP  action X
			 GenericP code)
{
    action->code = code;
}
#ifdef FS_FAST
#define action_set_code(a, c) ((a)->code = (c))
#endif /* defined (FS_FAST) */

void
action_iter_for_table PROTO_N ((action, full, proc, closure))
		      PROTO_T (ActionP  action X
			       BoolT    full X
			       void   (*proc) PROTO_S ((EntryP, GenericP)) X
			       GenericP closure)
{
    if (full) {
	types_iter_for_table (action_param (action), proc, closure);
	types_iter_for_table (action_result (action), proc, closure);
    }
}

/*
 * Local variables(smf):
 * eval: (include::add-path-entry "../os-interface" "../library")
 * eval: (include::add-path-entry "../generated")
 * end:
**/
