/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PComponent;
import org.piccolo2d.PRoot;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;
import org.piccolo2d.util.PUtil;

public final class POffscreenCanvas
implements PComponent {
    static final int DEFAULT_RENDER_QUALITY = 1;
    private final PBounds bounds;
    private PCamera camera;
    private int renderQuality = 1;
    private boolean opaque;
    private Color backgroundColor;

    public POffscreenCanvas(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be at least zero, was " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be at least zero, was " + height);
        }
        this.bounds = new PBounds(0.0, 0.0, width, height);
        this.setCamera(PUtil.createBasicScenegraph());
        this.opaque = false;
        this.backgroundColor = null;
    }

    public void render(Graphics2D graphics) {
        if (graphics == null) {
            throw new IllegalArgumentException("graphics must not be null");
        }
        if (this.opaque && this.backgroundColor != null) {
            graphics.setBackground(this.backgroundColor);
            graphics.clearRect(0, 0, (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
        }
        PPaintContext paintContext = new PPaintContext(graphics);
        paintContext.setRenderQuality(this.renderQuality);
        this.camera.fullPaint(paintContext);
    }

    public void setCamera(PCamera camera) {
        if (this.camera != null) {
            this.camera.setComponent(null);
        }
        this.camera = camera;
        if (camera != null) {
            camera.setComponent(this);
            camera.setBounds((PBounds)this.bounds.clone());
        }
    }

    public PCamera getCamera() {
        return this.camera;
    }

    public void setRenderQuality(int renderQuality) {
        if (renderQuality != 1 && renderQuality != 0) {
            throw new IllegalArgumentException("renderQuality must be one of PPaintContext.HIGH_QUALITY_RENDERING or PPaintContext.LOW_QUALITY_RENDERING, was " + renderQuality);
        }
        this.renderQuality = renderQuality;
    }

    public int getRenderQuality() {
        return this.renderQuality;
    }

    public void paintImmediately() {
    }

    public void popCursor() {
    }

    public void pushCursor(Cursor cursor) {
    }

    public void repaint(PBounds repaintBounds) {
    }

    public void setInteracting(boolean interacting) {
    }

    public PRoot getRoot() {
        return this.camera == null ? null : this.camera.getRoot();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackground(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }
}

