/*

    File: lang.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include "types.h"
#include "common.h"
#include "lang.h"

#ifdef DEAD_CODE
static const struct systypes xbsd_fstypes[] = {
/* BSD_FS_UNUSED  */   {"\x00" "unused"},
/* BSD_FS_SWAP    */   {"\x01" "swap"},
/* BSD_FS_V6      */   {"\x02" "Version 6"},
/* BSD_FS_V7      */   {"\x03" "Version 7"},
/* BSD_FS_SYSV    */   {"\x04" "System V"},
/* BSD_FS_V71K    */   {"\x05" "4.1BSD"},
/* BSD_FS_V8      */   {"\x06" "Eighth Edition"},
/* BSD_FS_BSDFFS  */   {"\x07" "4.2BSD"},
#ifdef __alpha__
/* BSD_FS_EXT2    */   {"\x08" "ext2"},
#else
/* BSD_FS_MSDOS   */   {"\x08" "MS-DOS"},
#endif
/* BSD_FS_BSDLFS  */   {"\x09" "4.4LFS"},
/* BSD_FS_OTHER   */   {"\x0a" "unknown"},
/* BSD_FS_HPFS    */   {"\x0b" "HPFS"},
/* BSD_FS_ISO9660 */   {"\x0c" "ISO-9660"},
/* BSD_FS_BOOT    */   {"\x0d" "boot"},
/* BSD_FS_ADOS    */   {"\x0e" "ADOS"},
/* BSD_FS_HFS     */   {"\x0f" "HFS"},
/* BSD_FS_ADVFS   */   {"\x10" "AdvFS"},
                       { NULL }
};

static const struct systypes sgi_sys_types[] = {
  /* SGI_VOLHDR   */  {"\x00" "SGI volhdr"   },
  /* 0x01         */  {"\x01" "SGI trkrepl"  },
  /* 0x02         */  {"\x02" "SGI secrepl"  },
  /* SGI_SWAP     */  {"\x03" "SGI raw"      },
  /* 0x04         */  {"\x04" "SGI bsd"      },
  /* 0x05         */  {"\x05" "SGI sysv"     },
  /* ENTIRE_DISK  */  {"\x06" "SGI volume"   },
  /* SGI_EFS      */  {"\x07" "SGI efs"      },
  /* 0x08         */  {"\x08" "SGI lvol"     },
  /* 0x09         */  {"\x09" "SGI rlvol"    },
  /* SGI_XFS      */  {"\x0a" "SGI xfs"      },
  /* SGI_XFSLOG   */  {"\x0b" "SGI xfslog"   },
  /* SGI_XLV      */  {"\x0c" "SGI xlv"      },
  /* SGI_XVM      */  {"\x0d" "SGI xvm"      },
  /* LINUX_SWAP   */  {"\x82" "Linux swap"   },
  /* LINUX_NATIVE */  {"\x83" "Linux native" },
  /* LINUX_LVM    */  {"\x8d" "Linux LVM"    },
  /* LINUX_RAID   */  {"\xfd" "Linux RAID"   },
                      { NULL             }
};
#endif

const char *partition_type(const unsigned char type, const struct systypes *parttype_name_table)
{
  int i;
  for (i=0; parttype_name_table[i].name; i++)
    if (parttype_name_table[i].name[0] == type)
      return parttype_name_table[i].name + 1;

  return NULL;
}
