/*

    File: file_crw.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "photorec.h"
#include "common.h"

static int header_check_crw(const unsigned char *buffer, const unsigned int buffer_size);
static int data_check_crw(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
const t_file_hint file_hint_crw= {
  .extension="crw",
  .description="Canon Raw picture",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=0,
  .stream=0,
  .recover=1,
  .header_check=&header_check_crw,
  .file_check=NULL,
  .data_check=&data_check_crw
};

static int header_check_crw(const unsigned char*buffer, const unsigned int buffer_size)
{
  return(((buffer[0]==0x49 && buffer[1]==0x49)||(buffer[0]==0x4D && buffer[1]==0x4D))
      && memcmp(buffer+6,"HEAPCCDR",8)==0);
}

static int data_check_crw(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  unsigned int i;
  for(i=(buffer_size/2)-13;i+13<buffer_size;i++)
  {
    if(buffer[i]==0x0A && buffer[i+1]==0x30 && buffer[i+2]==0xFE && buffer[i+3]==0x17 && buffer[i+13]==0)
    {
      file_recovery->file_size+=i+14-(buffer_size/2);
      ecrit_rapport("EOF CRW found\n");
      return 2;
    }
  }
  return 1;
}

