/*

    File: file_ext2_sb.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "common.h"
#include "ext2.h"
#include "photorec.h"

static int header_check_ext2_sb(const unsigned char *buffer, const unsigned int buffer_size);
const t_file_hint file_hint_ext2_sb= {
  .extension=NULL,
  .description="EXT2/EXT3 SB",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=1,
  .stream=0,
  .recover=0,
  .header_check=&header_check_ext2_sb,
  .data_check=NULL,
  .file_check=NULL
};

struct info_offset
{
  unsigned long int offset;
  unsigned int nbr;
};

typedef struct info_offset t_info_offset;

static int header_check_ext2_sb(const unsigned char *buffer, const unsigned int buffer_size)
{
  return (recover_EXT2(NULL,(const struct ext2_super_block *)buffer,NULL,0,0)==0);
}

