/*

    File: chgtype.c

    Copyright (C) 1998-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include "types.h"
#include "common.h"
#include "lang.h"
#include "intrf.h"
#include "fnctdsk.h"
#include "chgtype.h"

int change_part_type(const t_param_disk *disk_car,t_partition *partition, char **current_cmd)
{
  char response[100];
  int nbr=0;
  int i;
  struct MenuItem menuType[]=
  {
    { 'P', "Previous",""},
    { 'N', "Next","" },
    { 'Q', "Proceed","Go set the partition type"},
    { 0, NULL, NULL }
  };
  t_partition *new_partition=partition_new();
  dup_t_partition(new_partition,partition);
  aff_buffer(BUFFER_RESET,"Q");
  aff_buffer(BUFFER_ADD,"List of partition type\n");
  for(i=0;i<=0xFF;i++)
  {
    if(disk_car->arch->set_part_type(new_partition,i)==0)
    {
      const unsigned char *part_name;
      part_name=disk_car->arch->get_partition_name(new_partition);
      if(part_name!=NULL)
      {
	aff_buffer(BUFFER_ADD,"%02x %-20s ",i,part_name);
	nbr++;
	if(nbr==3)
	{
	  nbr=0;
	  aff_buffer(BUFFER_ADD,"\n");
	}
      }
    }
  }
  FREE(new_partition);
  aff_copy(stdscr);
  wmove(stdscr,4,0);
  aff_part(stdscr,AFF_PART_ORDER,disk_car,partition);
  if(*current_cmd==NULL)
    screen_buffer_display(stdscr,"",menuType);
  wmove(stdscr,23,0);
  wdoprintf(stdscr,"New partition type [current %02x] ? ",disk_car->arch->get_part_type(partition));
  if(*current_cmd!=NULL)
  {
    while(*current_cmd[0]==',')
      (*current_cmd)++;
    {
      int tmp_val= strtol(*current_cmd, NULL, 16);
      while(*current_cmd[0]!=',' && *current_cmd[0]!='\0')
	(*current_cmd)++;
      disk_car->arch->set_part_type(partition,tmp_val);
    }
  }
  else
  {
    if (get_string(response, sizeof(response), NULL) > 0) {
      int tmp_val = strtol(response, NULL, 16);
      disk_car->arch->set_part_type(partition,tmp_val);
    }
  }
  aff_part_rapport(disk_car,partition);
  return 0;
}


