/*

    File: common.h

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */
#define DEFAULT_SECTOR_SIZE     0x200

#define MAX_CYLINDERS 65535
#define MAX_HEADS 255
#define MAX_SECTORS 63

#define DISKNAME_MAX	64
#define DISKDESCRIPTION_MAX	128
#define TAB_PART 0x1BE
/* PARTITION TYPE */
#define P_NO_OS         0x00
#define P_12FAT         0x01
#define P_16FAT         0x04
#define P_EXTENDED      0x05
#define P_16FATBD       0x06
#define P_NTFS          0x07
#define P_HPFS          0x07
#define P_OS2MB         0x0A
#define P_32FAT         0x0B
#define P_32FAT_LBA     0x0C
#define P_16FATBD_LBA   0x0E
#define P_EXTENDX       0x0F
#define P_12FATH        0x11
#define P_16FATH        0x14
#define P_16FATBDH      0x16
#define P_NTFSH         0x17
#define P_32FATH        0x1B
#define P_32FAT_LBAH    0x1C
#define P_16FATBD_LBAH  0x1E
#define P_SYSV		0x63
#define P_NETWARE	0x65
#define P_OLDLINUX      0x81
#define P_LINSWAP       0x82
#define P_LINUX         0x83
#define P_LINUXEXTENDX  0x85
#define P_LVM		0x8E
#define P_FREEBSD       0xA5
#define P_OPENBSD       0xA6
#define P_NETBSD        0xA9
#define P_HFS		0xAF
#define P_HFSP		0xAF
#define P_SUN		0xBF
#define P_BEOS          0xEB
#define P_RAID		0xFD
#define P_UNK		255
#define NO_ORDER 	255
/* Partition SUN */
#define PSUN_BOOT	1
#define PSUN_ROOT	2
#define PSUN_SWAP	3
#define PSUN_USR	4
#define PSUN_WHOLE_DISK	5
#define PSUN_STAND	6
#define PSUN_VAR	7
#define PSUN_HOME	8
#define PSUN_ALT	9
#define PSUN_CACHEFS	10
#define PSUN_LINSWAP	P_LINSWAP
#define PSUN_LINUX	P_LINUX
#define PSUN_LVM	P_LVM
#define PSUN_RAID	P_RAID
#define PSUN_UNK	255

#define PMAC_DRIVER43 	1
#define PMAC_DRIVERATA 	2
#define PMAC_DRIVERIO 	3
#define PMAC_FREE	4
#define PMAC_FWDRIVER	5
#define PMAC_SWAP	0x82
#define PMAC_LINUX	0x83
#define PMAC_HFS	0xAF
#define PMAC_MAP	6
#define PMAC_PATCHES	7
#define PMAC_UNK	8
#define PMAC_NewWorld	9
#define PMAC_DRIVER	10
#define PMAC_MFS	11
#define PMAC_PRODOS	12

#define PXBOX_UNK	0
#define PXBOX_FATX	1

#define TESTDISK_O_RDONLY     00
#define TESTDISK_O_RDWR	      02
#define TESTDISK_O_DIRECT 040000
#define TESTDISK_O_READAHEAD_8K 04
#define TESTDISK_O_READAHEAD_32K 010

enum upart_type { UP_BEOS, UP_CRAMFS, UP_EXT2, UP_EXT3, UP_EXTENDED, UP_FAT12, UP_FAT16, UP_FAT32, UP_FATX, UP_FREEBSD,  UP_HFS, UP_HFSP, UP_HPFS, UP_JFS, UP_LINSWAP, UP_LINSWAP2, UP_LVM, UP_LVM2, UP_NETWARE, UP_NTFS, UP_OPENBSD, UP_OS2MB, UP_RAID, UP_RFS, UP_RFS2, UP_RFS3, UP_RFS4, UP_SUN, UP_SYSV4, UP_UFS, UP_UFS2, UP_UNK, UP_XFS, UP_XFS2, UP_XFS3, UP_XFS4};
typedef enum upart_type upart_type_t;
enum status_type { STATUS_DELETED, STATUS_PRIM, STATUS_PRIM_BOOT, STATUS_LOG, STATUS_EXT, STATUS_EXT_IN_EXT};
typedef enum status_type status_type_t;
enum errcode_type {BAD_NOERR, BAD_SS, BAD_ES, BAD_SH, BAD_EH, BAD_EBS, BAD_RS, BAD_SC, BAD_EC, BAD_SCOUNT};
typedef enum errcode_type errcode_type_t;
enum aff_part_type {AFF_PART_NONL, AFF_PART_ORDER, AFF_PART_SHORT};
typedef enum aff_part_type aff_part_type_t;
int ecrit_rapport(const char *_format, ...) __attribute__ ((format (printf, 1, 2)));
void ecrit_rapport_string(const char *string,const int max_length);

typedef struct param_disk_struct t_param_disk;
typedef struct partition_struct t_partition;
typedef struct CHS_struct t_CHS;

struct CHS_struct
{
  unsigned int cylinder;
  unsigned int head;
  unsigned int sector;
};

typedef struct list_part_struct t_list_part;
struct list_part_struct
{
  t_partition *part;
  t_list_part *prev;
  t_list_part *next;
  int to_be_removed;
};

typedef struct list_disk_struct t_list_disk;
struct list_disk_struct
{
  t_param_disk *disk;
  t_list_disk *prev;
  t_list_disk *next;
};

struct systypes {
  const unsigned int part_type;
  const unsigned char *name;
};

struct arch_fnct_struct
{
  const char *part_name;
  const char *part_name_option;
  const char *msg_part_type;
  t_list_part *(*read_part)(t_param_disk *disk_car, const int debug,const int saveheader);
  int (*write_part)(t_param_disk *disk_car, const t_list_part *list_part, const int ro, const int debug, const int align);
  t_list_part *(*init_part_order)(const t_param_disk *disk_car, t_list_part *list_part);
  int (*get_geometry_from_mbr)(const unsigned char *buffer, const int debug, t_CHS *geometry);
  int (*check_part)(t_param_disk *disk_car,const int debug,t_partition *partition, const int saveheader);
  int (*write_MBR_code)(t_param_disk *disk_car);
  t_list_part *(*add_partition)(t_param_disk *disk_car,t_list_part *list_part, const int debug, char **current_cmd);
  void (*set_prev_status)(const t_param_disk *disk_car, t_partition *partition);
  void (*set_next_status)(const t_param_disk *disk_car, t_partition *partition);
  int (*test_structure)(t_list_part *list_part);
  unsigned int (*get_part_type)(const t_partition *partition);
  int (*set_part_type)(t_partition *partition, unsigned int part_type);
  void (*init_structure)(const t_param_disk *disk_car,t_list_part *list_part, const int debug);
  int (*erase_list_part)(t_param_disk *disk_car);
  const unsigned char *(*get_partition_name)(const t_partition *partition);
  int (*is_part_known)(const t_partition *partition);
};

typedef struct arch_fnct_struct t_arch_fnct;

struct param_disk_struct
{
  uint64_t disk_size;
  t_CHS CHS;	/* logical CHS */
  int halt_on_errors;
  int write_used;
  int autodetect;
  unsigned int sector_size;
  const char *device;
  char description_txt[DISKDESCRIPTION_MAX];
  char description_short_txt[DISKDESCRIPTION_MAX];
  const char *(*description)(t_param_disk *disk_car);
  const char *(*description_short)(t_param_disk *disk_car);
  int (*read)(t_param_disk *disk_car,const unsigned int nbr_sector, void *nom_buffer, const uint64_t offset);
  int (*write)(t_param_disk *disk_car,const unsigned int nbr_sector, const void *nom_buffer, const uint64_t offset);
  int (*clean)(t_param_disk *disk_car);
  const t_arch_fnct *arch;
  void *data;
  uint64_t disk_real_size;
};

struct partition_struct
{
  uint64_t part_offset;
  uint64_t part_size;
  unsigned long int boot_sector;
  unsigned long int blocksize;
  unsigned int part_type_i386;
  unsigned int part_type_sun;
  unsigned int part_type_mac;
  unsigned int part_type_xbox;
  upart_type_t upart_type;
  status_type_t status;
  unsigned int order;
  errcode_type_t errcode;
  char name[80];
  char info[80];
  const t_arch_fnct *arch;
};

typedef struct fat_test_struct t_fat_test;
struct fat_test_struct
{
  unsigned long int offset;
  int f_fat12;
  int f_fat16;
  int f_fat32;
};
typedef struct my_data_struct t_my_data;
struct my_data_struct
{
  t_param_disk *disk_car;
  t_partition *partition;
  uint64_t offset;
};

void dup_t_partition(t_partition *dest, const t_partition *src);
int read_line(void);
char read_char(const char *);
void *MALLOC(size_t size);
void FREE(void *ptr);
char read_key(void);
char test_key(void);
unsigned int up2power(const unsigned int number);
void hd_update_geometry(t_param_disk *disk_car, const int allow_partial_last_cylinder, const int debug);
void hd_update_all_geometry(const t_list_disk * list_disk, const int allow_partial_last_cylinder, const int debug);
t_list_disk *hd_parse(t_list_disk *list_disk, const int debug, const t_arch_fnct *arch, const int testdisk_mode);
t_param_disk *file_test_availability(const char *device, const int debug, const t_arch_fnct *arch, const int testdisk_mode);
#if defined(__CYGWIN__) || defined(__MINGW32__)
t_param_disk *file_test_availability_win32(const char *device, const int debug, const t_arch_fnct *arch, const int testdisk_mode);
#endif
void my_sort(void *base, size_t nmemb, size_t size, int (*compar)(const void *, const void *));
int check_volume_name(const char *name,const unsigned int max_size);
void set_part_name(t_partition *partition,const char *src,const int max_size);
int rebuild_FAT_BS(t_param_disk *disk_car,t_partition *partition, const int debug, const int dump_ind,const int interface, const unsigned int expert, char**current_cmd);
#ifndef BSD_MAXPARTITIONS
#define	BSD_MAXPARTITIONS	8
#endif
#ifndef OPENBSD_MAXPARTITIONS
#define	OPENBSD_MAXPARTITIONS	16
#endif

#ifdef TESTDISK_LSB
#define le16(x)  (x)             /* x as little endian */
#define be16(x)  ((((x)&0xff00)>>8)                      | \
    (((x)&0x00ff)<<8))
#define le24(x)  (x)
#define le32(x)  (x)
#define be32(x)  ((((x)&0xff000000L)>>24)                | \
    (((x)&0x00ff0000L)>>8)                  | \
    (((x)&0x0000ff00L)<<8)                  | \
    (((x)&0x000000ffL)<<24))
#define le64(x)  (x)
#define be64(x)  ((((x)&0xff00000000000000LL)>>56)       | \
    (((x)&0x00ff000000000000LL)>>40)        | \
    (((x)&0x0000ff0000000000LL)>>24)        | \
    (((x)&0x000000ff00000000LL)>>8)         | \
    (((x)&0x00000000ff000000LL)<<8)         | \
    (((x)&0x0000000000ff0000LL)<<24)        | \
    (((x)&0x000000000000ff00LL)<<40)        | \
    (((x)&0x00000000000000ffLL)<<56))
#else /* bigendian */
#define le16(x)  ((((x)&0xff00)>>8)                      | \
    (((x)&0x00ff)<<8))
#define be16(x)  (x)
#define be24(x)  (x)
#define le24(x) ((((x) & 0x000000ffUL) << 16) | \
    ((x) & 0x0000ff00UL)        | \
    (((x) & 0x00ff0000UL) >> 16))
#define le32(x)  ((((x)&0xff000000L)>>24)                | \
    (((x)&0x00ff0000L)>>8)                  | \
    (((x)&0x0000ff00L)<<8)                  | \
    (((x)&0x000000ffL)<<24))
#define be32(x)  (x)
#define le64(x)  ((((x)&0xff00000000000000LL)>>56)       | \
    (((x)&0x00ff000000000000LL)>>40)        | \
    (((x)&0x0000ff0000000000LL)>>24)        | \
    (((x)&0x000000ff00000000LL)>>8)         | \
    (((x)&0x00000000ff000000LL)<<8)         | \
    (((x)&0x0000000000ff0000LL)<<24)        | \
    (((x)&0x000000000000ff00LL)<<40)        | \
    (((x)&0x00000000000000ffLL)<<56))
#define be64(x)  (x)
#endif
#ifndef HAVE_SNPRINTF
int snprintf(char *str, size_t size, const char *format, ...);
#endif
#ifndef HAVE_VSNPRINTF
int vsnprintf(char *str, size_t size, const char *format, va_list ap);
#endif
#ifndef HAVE_STRNCASECMP
int strncasecmp(const char * s1, const char * s2, size_t len);
#endif
FILE *create_file(const char *filename);

