/*

    File: sun.c

    Copyright (C) 2004-2005 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include "types.h"
#include "common.h"
#include "sun.h"
#include "fnctdsk.h"
#include "intrf.h"

#define SUN_LABEL_MAGIC          0xDABE
extern const t_arch_fnct arch_sun;

static int set_sun_info_i386(const t_param_disk *disk_car, const sun_partition_i386 *sunlabel,t_partition *partition, const int debug, const int dump_ind);
static int test_sun_i386(const t_param_disk *disk_car, const sun_partition_i386 *sunlabel,t_partition *partition,const int debug, const int dump_ind);

int check_sun_i386(t_param_disk *disk_car,t_partition *partition,const int debug)
{
  unsigned char buffer[DEFAULT_SECTOR_SIZE];
  sun_partition_i386 *sunlabel=(sun_partition_i386*)&buffer;
  if(disk_car->read(disk_car,sizeof(buffer), &buffer, partition->part_offset+0x200)!=0)
  { return 1; }
  if(test_sun_i386(disk_car,sunlabel,partition,debug,0)!=0)
    return 1;
  set_sun_info_i386(disk_car,sunlabel,partition,debug,0);
  return 0;
}

static int test_sun_i386(const t_param_disk *disk_car, const sun_partition_i386 *sunlabel,t_partition *partition,const int debug, const int dump_ind)
{
  if ((le16(sunlabel->magic) == SUN_LABEL_MAGIC)
      && (le32(sunlabel->magic_start) == SUN_LABEL_MAGIC_START))
  {
    partition->upart_type = UP_SUN;
    if(debug>0)
      ecrit_rapport("\nSUN Marker at %u/%u/%u\n", offset2cylinder(disk_car,partition->part_offset),offset2head(disk_car,partition->part_offset),offset2sector(disk_car,partition->part_offset));
    {
      int i;
      t_partition *new_partition=partition_new();
      for(i=0;i<16;i++)
      {
	if (sunlabel->partitions[i].num_sectors > 0
	    && sunlabel->partitions[i].id > 0)
//	    && sunlabel->partitions[i].id != WHOLE_DISK)
	{
	  partition_reset(new_partition);
	  new_partition->order=i;
	  new_partition->part_type_sun=sunlabel->partitions[i].id;
	  new_partition->part_offset=partition->part_offset+(uint64_t)le32(sunlabel->partitions[i].start_sector) * le16(sunlabel->sector_size);
	  new_partition->part_size=(uint64_t)le32(sunlabel->partitions[i].num_sectors) * le16(sunlabel->sector_size);
	  new_partition->status=STATUS_PRIM;
	  new_partition->arch=&arch_sun;
	  aff_part_rapport(disk_car,new_partition);
	}
      }
      FREE(new_partition);
    }
    return 0;
  }
  return 1;
}

int recover_sun_i386(t_param_disk *disk_car, const sun_partition_i386 *sunlabel, t_partition *partition,const int debug, const int dump_ind)
{
  if(test_sun_i386(disk_car,sunlabel,partition,debug,dump_ind)!=0)
    return 1;
  if(debug>0 || dump_ind!=0)
  {
    ecrit_rapport("\nrecover_sun\n");
    if(dump_ind!=0)
    {
      dump(stdscr,sunlabel,sizeof(*sunlabel));
    }
  }
  partition->part_size=(uint64_t)le32(sunlabel->partitions[2].num_sectors) * le16(sunlabel->sector_size);
  set_sun_info_i386(disk_car,sunlabel,partition,debug,dump_ind);
  partition->part_type_i386 = P_SUN;
  return 0;
}

static int set_sun_info_i386(const t_param_disk *disk_car,const sun_partition_i386 *sunlabel,t_partition *partition, const int debug, const int dump_ind)
{
  partition->info[0]='\0';
  partition->name[0]='\0';
  return 0;
}
