/*

    file: swap.h

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    this software is free software; you can redistribute it and/or modify
    it under the terms of the gnu general public license as published by
    the free software foundation; either version 2 of the license, or
    (at your option) any later version.
  
    this program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.  see the
    gnu general public license for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 59
    Temple Place - Suite 330, Boston MA 02111-1307, USA.

 */

#define PAGE_SIZE 0x1000        /* PAGE de 4K pour P_LINSWAP */
union swap_header {
  struct
  {
	char reserved[PAGE_SIZE - 10];
	char magic[10];
  } magic;
  struct
  {
	char         bootbits[1024];    /* Space for disklabel etc. */
	unsigned int version;
	unsigned int last_page;
	unsigned int nr_badpages;
/*	char volume_name[16]; */
	unsigned int padding[125];
	unsigned int badpages[1];
  } info;
};

int check_Linux_SWAP(t_param_disk *disk_car,t_partition *partition,const int debug);
int test_Linux_SWAP(t_param_disk *disk_car, const union swap_header *swap_header,t_partition *partition,const int debug, const int dump_ind);
int recover_Linux_SWAP(t_param_disk *disk_car, const union swap_header *swap_header,t_partition *partition,const int debug, const int dump_ind);
