/*

    File: file_mov.c

    Copyright (C) 1998-2006 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License along
    with this program; if not, write the Free Software Foundation, Inc., 51
    Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <stdio.h>
#include "types.h"
#include "photorec.h"
#include "common.h"

static const char* header_check_mov(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery);
#ifdef EXPERIMENTAL
static int data_check_mov(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery);
static unsigned int frame_offset=0;
#endif

const t_file_hint file_hint_mov= {
  .extension="mov",
  .description="mov/mp4/3gp/3g2/jp2",
  .min_header_distance=0,
  .min_filesize=0,
  .max_filesize=PHOTOREC_MAX_FILE_SIZE,
  .recover=1,
  .header_check=&header_check_mov,
#ifdef EXPERIMENTAL
  .data_check=&data_check_mov,
#else
  .data_check=NULL,
#endif
  .file_check=NULL
};

static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned int haystack_size, const unsigned char *needle, const unsigned int needle_size);

static const unsigned char * find_in_mem(const unsigned char *haystack, const unsigned int haystack_size, const unsigned char *needle, const unsigned int needle_size)
{
  unsigned int i;
  for(i=0;i<haystack_size-needle_size;i++)
    if(memcmp(&haystack[i],needle,needle_size)==0)
      return &haystack[i];
  return NULL;
}

static const char* header_check_mov(const unsigned char *buffer, const unsigned int buffer_size, const unsigned int safe_header_only,  t_file_recovery *file_recovery)
{
  unsigned int offset=0;
  unsigned int prev_atom_skip=0;
#ifdef EXPERIMENTAL
  if(file_recovery!=NULL && file_recovery->file_stat!=NULL && file_recovery->file_stat->file_hint==&file_hint_mov)
    return NULL;
  frame_offset=0;
#endif
  while(offset<buffer_size-8)
  {
    unsigned int atom_size;
    atom_size=(buffer[offset+0]<<24)+(buffer[offset+1]<<16)+(buffer[offset+2]<<8)+buffer[offset+3];
    if(atom_size<8 || atom_size>1024*1024*1024)
      return NULL;
#ifdef EXPERIMENTAL
    frame_offset=offset+atom_size;
#endif
    /* check for commun atom type */
    if(buffer[offset+4]=='p' && buffer[offset+5]=='n' && buffer[offset+6]=='o' && buffer[offset+7]=='t')
    {
      if(atom_size < 256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='w' && buffer[offset+5]=='i' && buffer[offset+6]=='d' && buffer[offset+7]=='e')
    {
      if(atom_size < 256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='m' && buffer[offset+5]=='o' && buffer[offset+6]=='o' && buffer[offset+7]=='v')
    {
      if(atom_size < 256*256*256)
	return file_hint_mov.extension;
      else
	return NULL;
    }
    if(buffer[offset+4]=='f' && buffer[offset+5]=='t' && buffer[offset+6]=='y' && buffer[offset+7]=='p')
    {
      if(atom_size>buffer_size-offset)
	atom_size=buffer_size-offset;
      if(find_in_mem(&buffer[offset+8], atom_size-8, "isom", 4)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "mp41", 4)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "mp42", 4)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "mmp4", 4)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "M4A", 3)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "M4B", 3)!=NULL ||
	  find_in_mem(&buffer[offset+8], atom_size-8, "M4P", 3)!=NULL)
	return "mp4";
      if(find_in_mem(&buffer[offset+8], atom_size-8, "3gp", 3)!=NULL)
	return "3gp";
      if(find_in_mem(&buffer[offset+8], atom_size-8, "3g2", 3)!=NULL)
	return "3g2";
      if(find_in_mem(&buffer[offset+8], atom_size-8, "jp2", 3)!=NULL)
	return "jp2";
      if(find_in_mem(&buffer[offset+8], atom_size-8, "qt", 2)!=NULL)
	return "mov";
    }
    if(prev_atom_skip==1 && buffer[offset+4]=='m' && buffer[offset+5]=='d' && buffer[offset+6]=='a' && buffer[offset+7]=='t')
      return file_hint_mov.extension;
    if(buffer[offset+4]=='s' && buffer[offset+5]=='k' && buffer[offset+6]=='i' && buffer[offset+7]=='p')
      prev_atom_skip=1;
    else
      prev_atom_skip=0;

    offset+=atom_size;
  }
  return NULL;
}

#ifdef EXPERIMENTAL
/* There are too much atom type */
static int data_check_mov(const unsigned char *buffer, const unsigned int buffer_size, t_file_recovery *file_recovery)
{
  unsigned int offset=frame_offset;
  if(file_recovery->file_size==0)
    offset+=buffer_size/2;
  else
    offset-=buffer_size/2;
  while(offset+4<buffer_size)
  {
    unsigned int atom_size;
    atom_size=(buffer[offset+0]<<24)+(buffer[offset+1]<<16)+(buffer[offset+2]<<8)+buffer[offset+3];
//    ecrit_rapport("file_mov.c: atom %c%c%c%c size %u\n", buffer[offset+4],buffer[offset+5],buffer[offset+6],buffer[offset+7], atom_size);
    if(atom_size>=8 && atom_size>1024*1024*1024 &&
	((buffer[offset+4]=='f' && buffer[offset+5]=='r' && buffer[offset+6]=='e' && buffer[offset+7]=='e') ||
	 (buffer[offset+4]=='s' && buffer[offset+5]=='k' && buffer[offset+6]=='i' && buffer[offset+7]=='p') ||
	 (buffer[offset+4]=='w' && buffer[offset+5]=='i' && buffer[offset+6]=='d' && buffer[offset+7]=='e') ||
	 (buffer[offset+4]=='p' && buffer[offset+5]=='n' && buffer[offset+6]=='o' && buffer[offset+7]=='t') ||
	 (buffer[offset+4]=='m' && buffer[offset+5]=='o' && buffer[offset+6]=='o' && buffer[offset+7]=='v') ||
	 (buffer[offset+4]=='m' && buffer[offset+5]=='d' && buffer[offset+6]=='a' && buffer[offset+7]=='t') ||
	 (buffer[offset+4]=='f' && buffer[offset+5]=='t' && buffer[offset+6]=='y' && buffer[offset+7]=='p') ||
	 (buffer[offset+4]=='t' && buffer[offset+5]=='r' && buffer[offset+6]=='a' && buffer[offset+7]=='k') ||
	 (buffer[offset+4]=='m' && buffer[offset+5]=='d' && buffer[offset+6]=='i' && buffer[offset+7]=='a') ||
	 (buffer[offset+4]=='s' && buffer[offset+5]=='t' && buffer[offset+6]=='b' && buffer[offset+7]=='l') ||
	 (buffer[offset+4]=='c' && buffer[offset+5]=='m' && buffer[offset+6]=='o' && buffer[offset+7]=='v') ||
	 (buffer[offset+4]=='d' && buffer[offset+5]=='c' && buffer[offset+6]=='o' && buffer[offset+7]=='m') ||
	 (buffer[offset+4]=='c' && buffer[offset+5]=='m' && buffer[offset+6]=='v' && buffer[offset+7]=='d') ||
	 (buffer[offset+4]=='j' && buffer[offset+5]=='p' && buffer[offset+6]=='2' && buffer[offset+7]=='h')
	)
      )
    {
      offset+=atom_size;
    }
    else
    {
      ecrit_rapport("file_mov.c: unknown atom %c%c%c%c\n", buffer[offset+4],buffer[offset+5],buffer[offset+6],buffer[offset+7]);
      if(offset>(buffer_size/2))
	offset-=buffer_size/2;
      file_recovery->file_size+=offset;
      frame_offset=0;
      return 2;
    }
  }
  frame_offset=offset;
  return 1;
}
#endif

